/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import org.geoserver.wps.executor.MaxExecutionTimeListener;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.DelegateProgressListener;

public class ProcessDismissedException
extends RuntimeException {
    private static final long serialVersionUID = -4266240008696107774L;

    public ProcessDismissedException() {
        this("The process execution has been dismissed");
    }

    public ProcessDismissedException(ProgressListener listener) {
        this(ProcessDismissedException.getMessageFromListener(listener));
    }

    private static String getMessageFromListener(ProgressListener listener) {
        MaxExecutionTimeListener max;
        while (!(listener instanceof MaxExecutionTimeListener) && listener instanceof DelegateProgressListener) {
            DelegateProgressListener d = (DelegateProgressListener)listener;
            listener = d.getDelegate();
        }
        if (listener instanceof MaxExecutionTimeListener && (max = (MaxExecutionTimeListener)listener).isExpired()) {
            return "The process executed got interrupted because it went beyond the configured limits of maxExecutionTime " + max.getMaxExecutionTime() / 1000L + " seconds, maxTotalTime " + max.getMaxTotalTime() / 1000L + " seconds";
        }
        return "The process execution has been dismissed";
    }

    public ProcessDismissedException(String message, Throwable cause) {
        super(message, cause);
    }

    public ProcessDismissedException(String message) {
        super(message);
    }

    public ProcessDismissedException(Throwable cause) {
        super(cause);
    }
}

