/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.security.CatalogMode;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.WPSInfo;

public class WPSInfoImpl
extends ServiceInfoImpl
implements WPSInfo {
    static final String KEY_CONNECTION_TIMEOUT = "connectionTimeout";
    static final Double DEFAULT_CONNECTION_TIMEOUT = 30.0;
    static final String KEY_RESOURCE_EXPIRATION_TIMEOUT = "resourceExpirationTimeout";
    static final int DEFAULT_RESOURCE_EXPIRATION_TIMEOUT = 300;
    static final String KEY_MAX_SYNCH = "maxSynchronousProcesses";
    static final int DEFAULT_MAX_SYNCH = Runtime.getRuntime().availableProcessors();
    static final String KEY_MAX_ASYNCH = "maxAsynchronousProcesses";
    static final int DEFAULT_MAX_ASYNCH = Runtime.getRuntime().availableProcessors();
    Double connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    Integer resourceExpirationTimeout = 300;
    Integer maxSynchronousProcesses = DEFAULT_MAX_SYNCH;
    Integer maxAsynchronousProcesses = DEFAULT_MAX_ASYNCH;
    List<ProcessGroupInfo> processGroups = new ArrayList<ProcessGroupInfo>();
    String storageDirectory;
    String externalOutputDirectory;
    CatalogMode catalogMode;
    int maxComplexInputSize;
    int maxSynchronousExecutionTime;
    Integer maxSynchronousTotalTime;
    int maxAsynchronousExecutionTime;
    Integer maxAsynchronousTotalTime;
    boolean remoteInputDisabled;

    public String getType() {
        return "WPS";
    }

    @Override
    public double getConnectionTimeout() {
        if (this.connectionTimeout == null) {
            MetadataMap md = this.getMetadata();
            if (md == null) {
                return DEFAULT_CONNECTION_TIMEOUT;
            }
            Double timeout = (Double)md.get(KEY_CONNECTION_TIMEOUT, Double.class);
            if (timeout == null) {
                return DEFAULT_CONNECTION_TIMEOUT;
            }
            this.connectionTimeout = timeout;
        }
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(double connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public int getResourceExpirationTimeout() {
        if (this.resourceExpirationTimeout == null) {
            MetadataMap md = this.getMetadata();
            if (md == null) {
                return 300;
            }
            Integer timeout = (Integer)md.get(KEY_RESOURCE_EXPIRATION_TIMEOUT, Integer.class);
            if (timeout == null) {
                return 300;
            }
            this.resourceExpirationTimeout = timeout;
        }
        return this.resourceExpirationTimeout;
    }

    @Override
    public void setResourceExpirationTimeout(int resourceExpirationTimeout) {
        this.resourceExpirationTimeout = resourceExpirationTimeout;
    }

    @Override
    public int getMaxSynchronousProcesses() {
        if (this.maxSynchronousProcesses == null) {
            MetadataMap md = this.getMetadata();
            if (md == null) {
                return DEFAULT_MAX_SYNCH;
            }
            Integer max = (Integer)md.get(KEY_MAX_SYNCH, Integer.class);
            if (max == null) {
                return DEFAULT_MAX_SYNCH;
            }
            this.maxSynchronousProcesses = max;
        }
        return this.maxSynchronousProcesses;
    }

    @Override
    public void setMaxSynchronousProcesses(int maxSynchronousProcesses) {
        this.maxSynchronousProcesses = maxSynchronousProcesses;
    }

    @Override
    public int getMaxAsynchronousProcesses() {
        if (this.maxAsynchronousProcesses == null) {
            MetadataMap md = this.getMetadata();
            if (md == null) {
                return DEFAULT_MAX_ASYNCH;
            }
            Integer max = (Integer)md.get(KEY_MAX_ASYNCH, Integer.class);
            if (max == null) {
                return DEFAULT_MAX_ASYNCH;
            }
            this.maxAsynchronousProcesses = max;
        }
        return this.maxAsynchronousProcesses;
    }

    @Override
    public void setMaxAsynchronousProcesses(int maxAsynchronousProcesses) {
        this.maxAsynchronousProcesses = maxAsynchronousProcesses;
    }

    @Override
    public List<ProcessGroupInfo> getProcessGroups() {
        return this.processGroups;
    }

    public void setProcessGroups(List<ProcessGroupInfo> processGroups) {
        this.processGroups = processGroups;
    }

    @Override
    public String getStorageDirectory() {
        return this.storageDirectory;
    }

    @Override
    public void setStorageDirectory(String storageDirectory) {
        this.storageDirectory = storageDirectory;
    }

    @Override
    public String getExternalOutputDirectory() {
        return this.externalOutputDirectory;
    }

    @Override
    public void setExternalOutputDirectory(String externalOutputDirectory) {
        this.externalOutputDirectory = externalOutputDirectory;
    }

    @Override
    public CatalogMode getCatalogMode() {
        if (this.catalogMode == null) {
            this.catalogMode = CatalogMode.HIDE;
        }
        return this.catalogMode;
    }

    @Override
    public void setCatalogMode(CatalogMode catalogMode) {
        this.catalogMode = catalogMode;
    }

    @Override
    public int getMaxComplexInputSize() {
        return this.maxComplexInputSize;
    }

    @Override
    public void setMaxComplexInputSize(int maxComplexInputSize) {
        this.maxComplexInputSize = maxComplexInputSize;
    }

    @Override
    public int getMaxSynchronousExecutionTime() {
        return this.maxSynchronousExecutionTime;
    }

    @Override
    public void setMaxSynchronousExecutionTime(int maxSynchronousExecutionTime) {
        this.maxSynchronousExecutionTime = maxSynchronousExecutionTime;
    }

    @Override
    public Integer getMaxSynchronousTotalTime() {
        return this.maxSynchronousTotalTime != null ? this.maxSynchronousTotalTime : this.maxSynchronousExecutionTime;
    }

    @Override
    public void setMaxSynchronousTotalTime(Integer maxSynchronousTotalTime) {
        this.maxSynchronousTotalTime = maxSynchronousTotalTime;
    }

    @Override
    public int getMaxAsynchronousExecutionTime() {
        return this.maxAsynchronousExecutionTime;
    }

    @Override
    public void setMaxAsynchronousExecutionTime(int maxAsynchronousExecutionTime) {
        this.maxAsynchronousExecutionTime = maxAsynchronousExecutionTime;
    }

    @Override
    public Integer getMaxAsynchronousTotalTime() {
        return this.maxAsynchronousTotalTime != null ? this.maxAsynchronousTotalTime : this.maxAsynchronousExecutionTime;
    }

    @Override
    public void setMaxAsynchronousTotalTime(Integer maxAsynchronousTotalTime) {
        this.maxAsynchronousTotalTime = maxAsynchronousTotalTime;
    }

    @Override
    public boolean isRemoteInputDisabled() {
        return this.remoteInputDisabled;
    }

    @Override
    public void setRemoteInputDisabled(boolean remoteInputDisabled) {
        this.remoteInputDisabled = remoteInputDisabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.catalogMode == null ? 0 : this.catalogMode.hashCode());
        result = 31 * result + (this.connectionTimeout == null ? 0 : this.connectionTimeout.hashCode());
        result = 31 * result + (this.maxAsynchronousProcesses == null ? 0 : this.maxAsynchronousProcesses.hashCode());
        result = 31 * result + this.maxAsynchronousExecutionTime;
        result = 31 * result + (this.maxAsynchronousTotalTime == null ? 0 : this.maxAsynchronousTotalTime.hashCode());
        result = 31 * result + this.maxComplexInputSize;
        result = 31 * result + this.maxSynchronousExecutionTime;
        result = 31 * result + (this.maxSynchronousTotalTime == null ? 0 : this.maxSynchronousTotalTime.hashCode());
        result = 31 * result + (this.maxSynchronousProcesses == null ? 0 : this.maxSynchronousProcesses.hashCode());
        result = 31 * result + (this.processGroups == null ? 0 : this.processGroups.hashCode());
        result = 31 * result + (this.resourceExpirationTimeout == null ? 0 : this.resourceExpirationTimeout.hashCode());
        result = 31 * result + (this.storageDirectory == null ? 0 : this.storageDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WPSInfoImpl other = (WPSInfoImpl)obj;
        if (this.catalogMode != other.catalogMode) {
            return false;
        }
        if (this.connectionTimeout == null ? other.connectionTimeout != null : !this.connectionTimeout.equals(other.connectionTimeout)) {
            return false;
        }
        if (this.maxAsynchronousProcesses == null ? other.maxAsynchronousProcesses != null : !this.maxAsynchronousProcesses.equals(other.maxAsynchronousProcesses)) {
            return false;
        }
        if (this.maxAsynchronousExecutionTime != other.maxAsynchronousExecutionTime) {
            return false;
        }
        if (this.maxAsynchronousTotalTime == null ? other.maxAsynchronousTotalTime != null : !this.maxAsynchronousTotalTime.equals(other.maxAsynchronousTotalTime)) {
            return false;
        }
        if (this.maxComplexInputSize != other.maxComplexInputSize) {
            return false;
        }
        if (this.maxSynchronousExecutionTime != other.maxSynchronousExecutionTime) {
            return false;
        }
        if (this.maxSynchronousTotalTime == null ? other.maxSynchronousTotalTime != null : !this.maxSynchronousTotalTime.equals(other.maxSynchronousTotalTime)) {
            return false;
        }
        if (this.maxSynchronousProcesses == null ? other.maxSynchronousProcesses != null : !this.maxSynchronousProcesses.equals(other.maxSynchronousProcesses)) {
            return false;
        }
        if (this.processGroups == null ? other.processGroups != null : !this.processGroups.equals(other.processGroups)) {
            return false;
        }
        if (this.resourceExpirationTimeout == null ? other.resourceExpirationTimeout != null : !this.resourceExpirationTimeout.equals(other.resourceExpirationTimeout)) {
            return false;
        }
        return !(this.storageDirectory == null ? other.storageDirectory != null : !this.storageDirectory.equals(other.storageDirectory));
    }
}

