/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.geoserver.wps.ProcessDismissedException;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;

class CancellingFeatureCollectionBuilder {
    CancellingFeatureCollectionBuilder() {
    }

    public static SimpleFeatureCollection wrap(FeatureCollection delegate, ProgressListener listener) {
        CancellingInvocationHandler cancellingInvocationHandler = new CancellingInvocationHandler(listener, delegate);
        Class[] interfaces = delegate instanceof SimpleFeatureCollection ? new Class[]{SimpleFeatureCollection.class} : new Class[]{FeatureCollection.class};
        SimpleFeatureCollection proxy = (SimpleFeatureCollection)Proxy.newProxyInstance(CancellingFeatureCollectionBuilder.class.getClassLoader(), interfaces, (InvocationHandler)cancellingInvocationHandler);
        return proxy;
    }

    private static class CancellingInvocationHandler
    implements InvocationHandler {
        ProgressListener listener;
        Object delegate;

        public CancellingInvocationHandler(ProgressListener listener, Object delegate) {
            this.listener = listener;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.listener.isCanceled()) {
                throw new ProcessDismissedException(this.listener);
            }
            Object result = method.invoke(this.delegate, args);
            if (result instanceof FeatureIterator) {
                Class[] interfaces = result instanceof SimpleFeatureIterator ? new Class[]{SimpleFeatureIterator.class} : new Class[]{FeatureIterator.class};
                result = Proxy.newProxyInstance(CancellingFeatureCollectionBuilder.class.getClassLoader(), interfaces, (InvocationHandler)new CancellingInvocationHandler(this.listener, result));
            }
            return result;
        }
    }
}

