/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.geoserver.wps.ProcessDismissedException;
import org.geotools.api.util.ProgressListener;

public class CancellingInputStream
extends FilterInputStream {
    ProgressListener listener;

    public CancellingInputStream(InputStream in, ProgressListener listener) {
        super(in);
        this.listener = listener;
    }

    @Override
    public int read() throws IOException {
        this.checkCancelled();
        return super.read();
    }

    private void checkCancelled() {
        if (this.listener.isCanceled()) {
            throw new ProcessDismissedException(this.listener);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkCancelled();
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCancelled();
        return super.read(b, off, len);
    }
}

