/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.List;
import org.geoserver.wps.ChainedProcessListener;
import org.geoserver.wps.WPSException;

class ChainedProcessListenerNotifier {
    private List<ChainedProcessListener> listeners;
    private String executionId;
    private String processName;
    private boolean chained;

    public ChainedProcessListenerNotifier(String executionId, String processName, boolean chained, List<ChainedProcessListener> listeners) {
        this.listeners = listeners;
        this.executionId = executionId;
        this.processName = processName;
        this.chained = chained;
    }

    public void fireStarted() throws WPSException {
        for (ChainedProcessListener listener : this.listeners) {
            listener.started(this.executionId, this.processName, this.chained);
        }
    }

    public void fireCompleted() throws WPSException {
        for (ChainedProcessListener listener : this.listeners) {
            listener.completed(this.executionId, this.processName);
        }
    }

    public void fireDismissed() throws WPSException {
        for (ChainedProcessListener listener : this.listeners) {
            listener.dismissed(this.executionId, this.processName);
        }
    }

    public void fireFailed(Exception e) throws WPSException {
        for (ChainedProcessListener listener : this.listeners) {
            listener.failed(this.executionId, this.processName, e);
        }
    }
}

