/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.DataType;
import net.opengis.wps10.DocumentOutputDefinitionType;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.LiteralDataType;
import net.opengis.wps10.OutputDataType;
import net.opengis.wps10.OutputDefinitionType;
import net.opengis.wps10.OutputDefinitionsType;
import net.opengis.wps10.OutputReferenceType;
import net.opengis.wps10.ProcessBriefType;
import net.opengis.wps10.ProcessFailedType;
import net.opengis.wps10.ProcessOutputsType1;
import net.opengis.wps10.ProcessStartedType;
import net.opengis.wps10.ResponseDocumentType;
import net.opengis.wps10.Wps10Factory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.Ows11Util;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wps.BinaryEncoderDelegate;
import org.geoserver.wps.CDataEncoderDelegate;
import org.geoserver.wps.RawDataEncoderDelegate;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.XMLEncoderDelegate;
import org.geoserver.wps.executor.CancellingFeatureCollectionBuilder;
import org.geoserver.wps.executor.CancellingOutputStream;
import org.geoserver.wps.executor.ExecuteRequest;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.ppio.BinaryPPIO;
import org.geoserver.wps.ppio.BoundingBoxPPIO;
import org.geoserver.wps.ppio.CDataPPIO;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.LiteralPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.ppio.RawDataPPIO;
import org.geoserver.wps.ppio.XMLPPIO;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.process.RawData;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.ProcessFactory;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.EMFUtils;
import org.springframework.context.ApplicationContext;

public class ExecuteResponseBuilder {
    static final Logger LOGGER = Logging.getLogger(ExecuteResponseBuilder.class);
    ExecuteType request;
    ExecutionStatus status;
    Map<String, Object> outputs;
    boolean verboseExceptions;
    ApplicationContext context;
    WPSResourceManager resourceManager;

    public ExecuteResponseBuilder(ExecuteType request, ApplicationContext context, ExecutionStatus status) {
        this.request = request;
        this.context = context;
        this.resourceManager = (WPSResourceManager)context.getBean(WPSResourceManager.class);
        this.status = status;
    }

    public void setOutputs(Map<String, Object> outputs) {
        this.outputs = outputs;
    }

    public ExecuteResponseType build() {
        return this.build((ProgressListener)new NullProgressListener());
    }

    public ExecuteResponseType build(ProgressListener listener) {
        ExecuteResponseType response;
        block27: {
            ExecuteRequest helper = new ExecuteRequest(this.request);
            Wps10Factory f = Wps10Factory.eINSTANCE;
            response = f.createExecuteResponseType();
            response.setLang("en");
            if (this.request.getBaseUrl() != null) {
                response.setServiceInstance(ResponseUtils.appendQueryString((String)ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"ows", null, (URLMangler.URLType)URLMangler.URLType.SERVICE), (String)""));
            }
            Name processName = helper.getProcessName();
            ProcessFactory pf = GeoServerProcessors.createProcessFactory(processName, false);
            ProcessBriefType process = f.createProcessBriefType();
            response.setProcess(process);
            process.setIdentifier((CodeType)EMFUtils.clone((EObject)this.request.getIdentifier(), (EFactory)Ows11Factory.eINSTANCE, (boolean)true));
            process.setProcessVersion(pf.getVersion(processName));
            process.setTitle(Ows11Util.languageString((InternationalString)pf.getTitle(processName)));
            process.setAbstract(Ows11Util.languageString((InternationalString)pf.getDescription(processName)));
            response.setStatus(f.createStatusType());
            if (this.status == null) {
                if (this.outputs == null) {
                    response.getStatus().setProcessAccepted("Process accepted.");
                } else {
                    response.getStatus().setProcessSucceeded("Process succeeded.");
                }
            } else {
                XMLGregorianCalendar gc = (XMLGregorianCalendar)Converters.convert((Object)this.status.getCreationTime(), XMLGregorianCalendar.class);
                response.getStatus().setCreationTime((Object)gc);
                if (this.status.getPhase() == ProcessState.QUEUED) {
                    response.getStatus().setProcessAccepted("Process accepted.");
                } else if (this.status.getPhase() == ProcessState.RUNNING) {
                    ProcessStartedType startedType = f.createProcessStartedType();
                    int progressPercent = Math.round(this.status.getProgress());
                    if (progressPercent < 0) {
                        LOGGER.warning("Progress reported is below zero, fixing it to 0: " + progressPercent);
                        progressPercent = 0;
                    } else if (progressPercent > 100) {
                        LOGGER.warning("Progress reported is above 100, fixing it to 100: " + progressPercent);
                        progressPercent = 100;
                    }
                    startedType.setPercentCompleted(new BigInteger(String.valueOf(progressPercent)));
                    startedType.setValue(this.status.getTask());
                    response.getStatus().setProcessStarted(startedType);
                } else if (this.status.getPhase() == ProcessState.SUCCEEDED) {
                    response.getStatus().setProcessSucceeded("Process succeeded.");
                } else {
                    ServiceException reportException = this.getException(this.status.getPhase());
                    this.setResponseFailed(response, reportException);
                }
            }
            if (this.status != null && this.status.isAsynchronous() && this.request.getBaseUrl() != null && this.status.getExecutionId() != null) {
                LinkedHashMap<String, String> kvp = new LinkedHashMap<String, String>();
                kvp.put("service", "WPS");
                kvp.put("version", "1.0.0");
                kvp.put("request", "GetExecutionStatus");
                kvp.put("executionId", this.status.getExecutionId());
                response.setStatusLocation(ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"ows", (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE));
            }
            if (helper.isLineageRequested()) {
                List<OutputDefinitionType> outputList;
                if (this.request.getDataInputs() != null && !this.request.getDataInputs().getInput().isEmpty()) {
                    response.setDataInputs(f.createDataInputsType1());
                    for (Object o : this.request.getDataInputs().getInput()) {
                        InputType input = (InputType)o;
                        response.getDataInputs().getInput().add((Object)EMFUtils.clone((EObject)input, (EFactory)f, (boolean)true));
                    }
                }
                if ((outputList = helper.getRequestedOutputs()) != null) {
                    OutputDefinitionsType outputs = f.createOutputDefinitionsType();
                    response.setOutputDefinitions(outputs);
                    for (OutputDefinitionType outputDefinitionType : outputList) {
                        outputs.getOutput().add((Object)EMFUtils.clone((EObject)outputDefinitionType, (EFactory)f, (boolean)true));
                    }
                }
            }
            if (this.status == null || this.status.getException() != null || this.outputs == null) break block27;
            ProcessOutputsType1 processOutputs = f.createProcessOutputsType1();
            response.setProcessOutputs(processOutputs);
            Map resultInfo = pf.getResultInfo(processName, null);
            if (Optional.ofNullable(this.request.getResponseForm()).map(rf -> rf.getResponseDocument()).map(rd -> rd.getOutput()).filter(output -> !output.isEmpty()).isPresent()) {
                EList outputs = this.request.getResponseForm().getResponseDocument().getOutput();
                for (Object object : outputs) {
                    if (!listener.isCanceled()) {
                        DocumentOutputDefinitionType odt = (DocumentOutputDefinitionType)object;
                        String key = odt.getIdentifier().getValue();
                        Parameter outputParam = (Parameter)resultInfo.get(key);
                        if (outputParam == null) {
                            throw new WPSException("Unknown output " + key + " possible values are: " + resultInfo.keySet());
                        }
                        String mimeType = odt.getMimeType();
                        OutputDataType output3 = this.encodeOutput(key, outputParam, mimeType, odt.isAsReference(), listener);
                        processOutputs.getOutput().add((Object)output3);
                        continue;
                    }
                    break;
                }
            } else {
                for (String string : this.outputs.keySet()) {
                    if (!listener.isCanceled()) {
                        Parameter outputParam = (Parameter)resultInfo.get(string);
                        OutputDataType output4 = this.encodeOutput(string, outputParam, null, false, listener);
                        processOutputs.getOutput().add((Object)output4);
                        continue;
                    }
                    break;
                }
            }
        }
        return response;
    }

    OutputDataType encodeOutput(String key, Parameter<?> outputParam, String mimeType, boolean reference, ProgressListener listener) {
        OutputDataType output;
        block21: {
            ProcessParameterIO ppio;
            Wps10Factory f = Wps10Factory.eINSTANCE;
            output = f.createOutputDataType();
            output.setIdentifier(Ows11Util.code((String)key));
            output.setTitle(Ows11Util.languageString((InternationalString)outputParam.description));
            Object o = this.outputs.get(key);
            if (mimeType == null) {
                mimeType = this.getOutputMimeType(key);
            }
            if ((ppio = ProcessParameterIO.find(outputParam, this.context, mimeType)) == null) {
                throw new WPSException("Don't know how to encode output " + key + " in mime type " + mimeType);
            }
            try {
                if (reference && ppio instanceof ComplexPPIO) {
                    String mime;
                    OutputReferenceType outputReference = f.createOutputReferenceType();
                    output.setReference(outputReference);
                    ComplexPPIO cppio = (ComplexPPIO)ppio;
                    String name = key + "." + cppio.getFileExtension(o);
                    Resource outputResource = this.resourceManager.getOutputResource(this.status.getExecutionId(), name);
                    try (CancellingOutputStream os = new CancellingOutputStream(outputResource.out(), listener);){
                        if (o instanceof FeatureCollection) {
                            o = CancellingFeatureCollectionBuilder.wrap((FeatureCollection)o, listener);
                        }
                        cppio.encode(o, os);
                    }
                    if (o instanceof RawData) {
                        RawData rawData = (RawData)o;
                        mime = rawData.getMimeType();
                    } else {
                        mime = cppio.getMimeType();
                    }
                    String url = this.resourceManager.getOutputResourceUrl(this.status.getExecutionId(), name, this.request.getBaseUrl(), mime);
                    outputReference.setHref(url);
                    outputReference.setMimeType(mime);
                    break block21;
                }
                DataType data = f.createDataType();
                output.setData(data);
                if (ppio instanceof LiteralPPIO) {
                    LiteralDataType literal = f.createLiteralDataType();
                    data.setLiteralData(literal);
                    literal.setValue(((LiteralPPIO)ppio).encode(o));
                    break block21;
                }
                if (ppio instanceof BoundingBoxPPIO) {
                    BoundingBoxType bbox = ((BoundingBoxPPIO)ppio).encode(o);
                    data.setBoundingBoxData(bbox);
                    break block21;
                }
                if (!(ppio instanceof ComplexPPIO)) break block21;
                ComplexDataType complex = f.createComplexDataType();
                data.setComplexData(complex);
                ComplexPPIO cppio = (ComplexPPIO)ppio;
                complex.setMimeType(cppio.getMimeType());
                if (o == null) {
                    complex.getData().add(null);
                    break block21;
                }
                if (cppio instanceof RawDataPPIO) {
                    RawData rawData = (RawData)o;
                    complex.setMimeType(rawData.getMimeType());
                    complex.setEncoding("base64");
                    complex.getData().add((Object)new RawDataEncoderDelegate(rawData));
                    break block21;
                }
                if (cppio instanceof XMLPPIO) {
                    complex.getData().add((Object)new XMLEncoderDelegate((XMLPPIO)cppio, o));
                    break block21;
                }
                if (cppio instanceof CDataPPIO) {
                    complex.getData().add((Object)new CDataEncoderDelegate((CDataPPIO)cppio, o));
                    break block21;
                }
                if (cppio instanceof BinaryPPIO) {
                    complex.setEncoding("base64");
                    complex.getData().add((Object)new BinaryEncoderDelegate((BinaryPPIO)cppio, o));
                    break block21;
                }
                throw new WPSException("Don't know how to encode an output whose PPIO is " + cppio);
            }
            catch (Exception e) {
                throw new WPSException("Failed to encode the " + key + " output", e);
            }
        }
        return output;
    }

    void setResponseFailed(ExecuteResponseType response, ServiceException reportException) {
        Wps10Factory f = Wps10Factory.eINSTANCE;
        ProcessFailedType failedType = f.createProcessFailedType();
        ExceptionReportType report = Ows11Util.exceptionReport((ServiceException)reportException, (boolean)this.verboseExceptions, (String)"1.1.0");
        failedType.setExceptionReport(report);
        response.getStatus().setProcessFailed(failedType);
    }

    private String getOutputMimeType(String key) {
        if (this.request.getResponseForm() == null) {
            return null;
        }
        OutputDefinitionType odt = this.request.getResponseForm().getRawDataOutput();
        ResponseDocumentType responseDocument = this.request.getResponseForm().getResponseDocument();
        if (responseDocument != null && odt == null) {
            for (OutputDefinitionType curr : responseDocument.getOutput()) {
                if (!curr.getIdentifier().getValue().equals(key)) continue;
                odt = curr;
                break;
            }
        }
        if (odt != null) {
            return odt.getMimeType();
        }
        return null;
    }

    private ServiceException getException(ProcessState phase) {
        if (phase == ProcessState.DISMISSING) {
            return new WPSException("Process was cancelled by the administrator");
        }
        if (this.status.getException() instanceof WPSException) {
            return (WPSException)((Object)this.status.getException());
        }
        return new WPSException("Process failed during execution", this.status.getException());
    }
}

