/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Logger;
import net.opengis.wps10.ExecuteType;
import org.geoserver.wps.executor.ProcessState;
import org.geotools.api.feature.type.Name;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ExecutionStatus
implements Serializable,
Comparable<ExecutionStatus> {
    static final Logger LOGGER = Logging.getLogger(ExecutionStatus.class);
    private static final long serialVersionUID = -2433524030271115410L;
    public static final String NODE_IDENTIFIER = ExecutionStatus.getNodeIdentifier();
    Name processName;
    String executionId;
    boolean asynchronous;
    ProcessState phase;
    float progress;
    String userName;
    Date creationTime;
    Date completionTime = null;
    Date lastUpdated;
    Date expirationDate = null;
    Date estimatedCompletion = null;
    Date nextPoll = null;
    String task;
    Throwable exception;
    transient ExecuteType request;
    String nodeId;

    private static String getNodeIdentifier() {
        try {
            return ExecutionStatus.getLocalAddress().getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static InetAddress getLocalAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                if (ni.getName() != null && ni.getName().startsWith("vmnet")) continue;
                Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress() || inetAddr instanceof Inet6Address) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address");
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public ExecutionStatus(Name processName, String executionId, boolean asynchronous) {
        this.processName = processName;
        this.executionId = executionId;
        this.setPhase(ProcessState.QUEUED);
        this.lastUpdated = this.creationTime = new Date();
        this.asynchronous = asynchronous;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            this.userName = authentication.getName();
        }
        this.nodeId = NODE_IDENTIFIER;
    }

    public ExecutionStatus(ExecutionStatus other) {
        this.processName = other.processName;
        this.executionId = other.executionId;
        this.setPhase(other.phase);
        this.progress = other.progress;
        this.task = other.task;
        this.exception = other.exception;
        this.creationTime = other.creationTime;
        this.completionTime = other.completionTime;
        this.request = other.request;
        this.asynchronous = other.asynchronous;
        this.userName = other.userName;
        this.nodeId = other.nodeId;
        this.lastUpdated = other.lastUpdated;
        this.expirationDate = other.expirationDate;
        this.estimatedCompletion = other.estimatedCompletion;
        this.nextPoll = other.nextPoll;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
        this.setPhase(ProcessState.FAILED);
    }

    public Name getProcessName() {
        return this.processName;
    }

    public String getSimpleProcessName() {
        return this.processName.toString();
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public ProcessState getPhase() {
        return this.phase;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProcessName(Name processName) {
        this.processName = processName;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void setPhase(ProcessState phase) {
        this.phase = phase;
        if (phase != null && phase.isExecutionCompleted() && this.completionTime == null) {
            this.completionTime = new Date();
        }
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getTask() {
        return this.task;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ExecuteType getRequest() {
        return this.request;
    }

    public void setRequest(ExecuteType request) {
        this.request = request;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getEstimatedCompletion() {
        return this.estimatedCompletion;
    }

    public void setEstimatedCompletion(Date estimatedCompletion) {
        this.estimatedCompletion = estimatedCompletion;
    }

    public Date getNextPoll() {
        return this.nextPoll;
    }

    public void setNextPoll(Date nextPoll) {
        this.nextPoll = nextPoll;
    }

    public String toString() {
        return "ExecutionStatus [processName=" + this.processName + ", executionId=" + this.executionId + ", asynchronous=" + this.asynchronous + ", phase=" + this.phase + ", progress=" + this.progress + ", userName=" + this.userName + ", creationTime=" + this.creationTime + ", completionTime=" + this.completionTime + ", lastUpdated=" + this.lastUpdated + ", expirationDate=" + this.expirationDate + ", estimatedCompletion=" + this.estimatedCompletion + ", nextPoll=" + this.nextPoll + ", task=" + this.task + ", exception=" + this.exception + ", nodeId=" + this.nodeId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.asynchronous ? 1231 : 1237);
        result = 31 * result + (this.completionTime == null ? 0 : this.completionTime.hashCode());
        result = 31 * result + (this.creationTime == null ? 0 : this.creationTime.hashCode());
        result = 31 * result + (this.executionId == null ? 0 : this.executionId.hashCode());
        result = 31 * result + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        result = 31 * result + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
        result = 31 * result + (this.estimatedCompletion == null ? 0 : this.estimatedCompletion.hashCode());
        result = 31 * result + (this.nextPoll == null ? 0 : this.nextPoll.hashCode());
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.phase == null ? 0 : this.phase.hashCode());
        result = 31 * result + (this.processName == null ? 0 : this.processName.hashCode());
        result = 31 * result + Float.floatToIntBits(this.progress);
        result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionStatus other = (ExecutionStatus)obj;
        if (this.asynchronous != other.asynchronous) {
            return false;
        }
        if (this.completionTime == null ? other.completionTime != null : !this.completionTime.equals(other.completionTime)) {
            return false;
        }
        if (this.creationTime == null ? other.creationTime != null : !this.creationTime.equals(other.creationTime)) {
            return false;
        }
        if (this.executionId == null ? other.executionId != null : !this.executionId.equals(other.executionId)) {
            return false;
        }
        if (this.lastUpdated == null ? other.lastUpdated != null : !this.lastUpdated.equals(other.lastUpdated)) {
            return false;
        }
        if (this.expirationDate == null ? other.expirationDate != null : !this.expirationDate.equals(other.expirationDate)) {
            return false;
        }
        if (this.estimatedCompletion == null ? other.estimatedCompletion != null : !this.estimatedCompletion.equals(other.estimatedCompletion)) {
            return false;
        }
        if (this.nextPoll == null ? other.nextPoll != null : !this.nextPoll.equals(other.nextPoll)) {
            return false;
        }
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.phase != other.phase) {
            return false;
        }
        if (this.processName == null ? other.processName != null : !this.processName.equals((Object)other.processName)) {
            return false;
        }
        if (Float.floatToIntBits(this.progress) != Float.floatToIntBits(other.progress)) {
            return false;
        }
        if (this.task == null ? other.task != null : !this.task.equals(other.task)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    @Override
    public int compareTo(ExecutionStatus o) {
        return this.executionId.compareTo(o.executionId);
    }
}

