/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import net.opengis.wfs.GetFeatureType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.MethodType;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.wfs.WebFeatureService;
import org.geoserver.wfs.WebFeatureService20;
import org.geoserver.wfs.kvp.GetFeatureKvpRequestReader;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wps.executor.AbstractInputProvider;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geotools.api.util.ProgressListener;
import org.springframework.context.ApplicationContext;

public class InternalWFSInputProvider
extends AbstractInputProvider {
    private ApplicationContext context;

    public InternalWFSInputProvider(InputType input, ProcessParameterIO ppio, ApplicationContext context) {
        super(input, ppio);
        this.context = context;
    }

    @Override
    protected Object getValueInternal(ProgressListener listener) throws Exception {
        FeatureCollectionResponse featureCollectionType;
        WebFeatureService wfs;
        Object gft = null;
        InputReferenceType ref = this.input.getReference();
        if (ref.getMethod() == MethodType.POST_LITERAL) {
            gft = ref.getBody();
        } else {
            String version = this.getVersion(ref.getHref());
            GetFeatureKvpRequestReader reader = "2.0.0".equals(version) ? (GetFeatureKvpRequestReader)this.context.getBean("getFeature20KvpReader") : (GetFeatureKvpRequestReader)this.context.getBean("getFeatureKvpReader");
            gft = this.kvpParse(ref.getHref(), (KvpRequestReader)reader);
        }
        if (gft instanceof GetFeatureType) {
            wfs = (WebFeatureService)this.context.getBean("wfsServiceTarget");
            featureCollectionType = wfs.getFeature((GetFeatureType)gft);
            return ((ComplexPPIO)this.ppio).decode(featureCollectionType.getAdaptee());
        }
        if (gft instanceof net.opengis.wfs20.GetFeatureType) {
            wfs = (WebFeatureService20)this.context.getBean("wfsService20Target");
            featureCollectionType = wfs.getFeature((net.opengis.wfs20.GetFeatureType)gft);
            return ((ComplexPPIO)this.ppio).decode(featureCollectionType.getAdaptee());
        }
        if (gft == null) {
            throw new UnsupportedOperationException("We didn't get a valid GetFeatureType.");
        }
        throw new UnsupportedOperationException("We can't handle the inner WFS request. Provided GetFeatureType is of class " + gft.getClass().getCanonicalName() + "\nContent: [" + gft + "]\n");
    }

    @Override
    public int longStepCount() {
        return 0;
    }
}

