/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.geoserver.wps.ProcessDismissedException;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.InputProvider;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.data.util.SubProgressListener;
import org.geotools.util.SimpleInternationalString;

class LazyInputMap
extends AbstractMap<String, Object> {
    private static ProgressListener DEFAULT_LISTENER = new NullProgressListener();
    Map<String, InputProvider> providers = new LinkedHashMap<String, InputProvider>();
    Map<String, Object> values = new HashMap<String, Object>();
    boolean parsed = false;
    ProgressListener listener = DEFAULT_LISTENER;

    public LazyInputMap(Map<String, InputProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Object get(Object key) {
        if (this.listener.isCanceled()) {
            throw new ProcessDismissedException(this.listener);
        }
        this.parseInputs();
        return this.values.get(key);
    }

    private void parseInputs() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        int totalSteps = 0;
        for (InputProvider provider : this.providers.values()) {
            totalSteps += provider.longStepCount();
        }
        this.listener.started();
        float stepsSoFar = 0.0f;
        for (InputProvider provider : this.providers.values()) {
            this.listener.setTask((InternationalString)new SimpleInternationalString("Retrieving/parsing process input: " + provider.getInputId()));
            try {
                float providerLongSteps = provider.longStepCount();
                Object subListener = providerLongSteps > 0.0f ? new SubProgressListener(this.listener, stepsSoFar / (float)totalSteps * 100.0f, providerLongSteps / (float)totalSteps * 100.0f) : new NullProgressListener();
                stepsSoFar += providerLongSteps;
                subListener.started();
                subListener.progress(0.0f);
                Object value = provider.getValue((ProgressListener)subListener);
                this.values.put(provider.getInputId(), value);
            }
            catch (Exception e) {
                this.listener.exceptionOccurred((Throwable)e);
                if (e instanceof WPSException) {
                    throw (WPSException)((Object)e);
                }
                throw new WPSException("Failed to retrieve value for input " + provider.getInputId(), e);
            }
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        for (String key : this.providers.keySet()) {
            result.add(new DeferredEntry(key));
        }
        return result;
    }

    public int longStepCount() {
        int count = 0;
        for (InputProvider provider : this.providers.values()) {
            count += provider.longStepCount();
        }
        return count;
    }

    public void setListener(ProgressListener listener) {
        this.listener = listener;
    }

    public class DeferredEntry
    implements Map.Entry<String, Object> {
        private String key;

        public DeferredEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            LazyInputMap.this.parseInputs();
            return LazyInputMap.this.values.get(this.key);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

