/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.InputProvider;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.data.util.SubProgressListener;

class ListInputProvider
implements InputProvider {
    List<InputProvider> providers = new ArrayList<InputProvider>();
    String inputId;
    List<Object> value;
    int maxItems;

    public ListInputProvider(InputProvider provider, int maxItems) {
        this.providers.add(provider);
        this.inputId = provider.getInputId();
        this.maxItems = maxItems;
    }

    @Override
    public Object getValue(ProgressListener listener) throws Exception {
        float totalSteps = this.longStepCount();
        float stepsSoFar = 0.0f;
        if (this.value == null) {
            if (this.maxItems > 0 && this.providers.size() > this.maxItems) {
                throw new WPSException("Too many values for input " + this.getInputId() + ", the max is " + this.maxItems, "NoApplicableCode", this.getInputId());
            }
            this.value = new ArrayList<Object>();
            for (InputProvider provider : this.providers) {
                float providerLongSteps = provider.longStepCount();
                Object subListener = providerLongSteps > 0.0f ? new SubProgressListener(listener, stepsSoFar / totalSteps * 100.0f, providerLongSteps / totalSteps * 100.0f) : new NullProgressListener();
                totalSteps += providerLongSteps;
                Object pv = provider.getValue((ProgressListener)subListener);
                this.value.add(pv);
            }
        }
        return this.value;
    }

    @Override
    public String getInputId() {
        return this.inputId;
    }

    public void add(InputProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public boolean resolved() {
        return this.value != null;
    }

    @Override
    public int longStepCount() {
        int count = 0;
        for (InputProvider ip : this.providers) {
            count += ip.longStepCount();
        }
        return count;
    }
}

