/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wps.ProcessDismissedException;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.DelegateProgressListener;
import org.geotools.util.logging.Logging;

public class MaxExecutionTimeListener
extends DelegateProgressListener {
    static final Logger LOGGER = Logging.getLogger(MaxExecutionTimeListener.class);
    long maxExecutionTime;
    long maxTotalTime;
    long queuedTime;
    long startTime;

    public MaxExecutionTimeListener(ProgressListener progress, long maxExecutionTime, long maxTotalTime) {
        super(progress);
        if (maxTotalTime > 0L && maxTotalTime < maxExecutionTime) {
            LOGGER.log(Level.WARNING, "The maximum total queuing and execution time allowed for processes is less than the maximum allowed execution time");
        }
        this.maxExecutionTime = maxExecutionTime;
        this.maxTotalTime = maxTotalTime;
        this.queuedTime = System.currentTimeMillis();
        this.startTime = 0L;
    }

    public boolean isCanceled() {
        if (this.isExpired()) {
            return true;
        }
        return super.isCanceled();
    }

    private void checkNotExpired() {
        if (this.isExpired()) {
            throw new ProcessDismissedException((ProgressListener)this);
        }
    }

    public boolean isExpired() {
        boolean maxExecutionTimeExceeded = this.maxExecutionTime > 0L && this.startTime > 0L && System.currentTimeMillis() - this.startTime > this.maxExecutionTime;
        boolean maxTotalTimeExceeded = this.maxTotalTime > 0L && System.currentTimeMillis() - this.queuedTime > this.maxTotalTime;
        return maxExecutionTimeExceeded || maxTotalTimeExceeded;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public long getMaxTotalTime() {
        return this.maxTotalTime;
    }

    public void started() {
        this.startTime = System.currentTimeMillis();
        this.checkNotExpired();
        super.started();
    }

    public void complete() {
        this.checkNotExpired();
        super.complete();
    }

    public InternationalString getTask() {
        this.checkNotExpired();
        return super.getTask();
    }

    public void progress(float progress) {
        this.checkNotExpired();
        super.progress(progress);
    }

    public float getProgress() {
        this.checkNotExpired();
        return super.getProgress();
    }

    public void setTask(InternationalString task) {
        this.checkNotExpired();
        super.setTask(task);
    }

    public void warningOccurred(String source, String location, String warning) {
        this.checkNotExpired();
        super.warningOccurred(source, location, warning);
    }
}

