/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.geoserver.wps.WPSException;

class MaxSizeInputStream
extends ProxyInputStream {
    private long maxSize;
    private String inputId;
    private long count;

    protected MaxSizeInputStream(InputStream in, String inputId, long maxSize) {
        super(in);
        this.inputId = inputId;
        this.maxSize = maxSize;
    }

    protected synchronized void afterRead(int n) {
        if (n != -1) {
            this.count += (long)n;
        }
        if (this.count > this.maxSize) {
            throw new WPSException("Exceeded maximum input size of " + this.maxSize + " bytes while reading input " + this.inputId, "NoApplicableCode", this.inputId);
        }
    }
}

