/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.Collection;
import org.geoserver.wps.executor.InputProvider;
import org.geoserver.wps.validator.ValidationException;
import org.geotools.api.util.ProgressListener;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ValidatingInputProvider
implements InputProvider {
    InputProvider delegate;
    Collection<Validator> validators;

    public static InputProvider wrap(InputProvider delegate, Collection<Validator> validators) {
        if (validators == null || validators.isEmpty()) {
            return delegate;
        }
        return new ValidatingInputProvider(delegate, validators);
    }

    private ValidatingInputProvider(InputProvider delegate, Collection<Validator> validators) {
        this.delegate = delegate;
        this.validators = validators;
    }

    @Override
    public Object getValue(ProgressListener subListener) throws Exception {
        Object value = this.delegate.getValue(subListener);
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(value, this.getInputId());
        for (Validator v : this.validators) {
            if (!v.supports(value.getClass())) continue;
            v.validate(value, (Errors)errors);
        }
        if (errors.hasErrors()) {
            throw new ValidationException((Errors)errors, this.getInputId());
        }
        return value;
    }

    @Override
    public String getInputId() {
        return this.delegate.getInputId();
    }

    @Override
    public boolean resolved() {
        return this.delegate.resolved();
    }

    @Override
    public int longStepCount() {
        return this.delegate.longStepCount();
    }
}

