/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.geoserver.wps.ppio.CDataPPIO;
import org.geotools.process.vector.AggregateProcess;

public class AggregateProcessJSONPPIO
extends CDataPPIO {
    protected AggregateProcessJSONPPIO() {
        super(AggregateProcess.Results.class, AggregateProcess.Results.class, "application/json");
    }

    @Override
    public void encode(Object value, OutputStream output) throws Exception {
        AggregateProcess.Results processResult = (AggregateProcess.Results)value;
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("AggregationAttribute", processResult.getAggregateAttribute());
        json.put("AggregationFunctions", this.extractAggregateFunctionsNames(processResult));
        if (processResult.getGroupByAttributes() == null || processResult.getGroupByAttributes().isEmpty()) {
            json.put("GroupByAttributes", new String[0]);
            json.put("AggregationResults", new Number[][]{this.encodeSimpleResult(processResult)});
        } else {
            json.put("GroupByAttributes", processResult.getGroupByAttributes().toArray());
            json.put("AggregationResults", processResult.getGroupByResult().toArray());
        }
        output.write(JSONObject.fromObject(json).toString().getBytes());
    }

    private Number[] encodeSimpleResult(AggregateProcess.Results processResult) {
        return (Number[])processResult.getFunctions().stream().map(function -> (Number)processResult.getResults().get(function)).toArray(Number[]::new);
    }

    private String[] extractAggregateFunctionsNames(AggregateProcess.Results result) {
        return (String[])result.getFunctions().stream().map(Enum::name).toArray(String[]::new);
    }

    @Override
    public Object decode(InputStream input) throws Exception {
        throw new UnsupportedOperationException("JSON parsing is not supported");
    }

    @Override
    public Object decode(String input) throws Exception {
        throw new UnsupportedOperationException("JSON parsing is not supported");
    }

    @Override
    public final String getFileExtension() {
        return "json";
    }
}

