/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class GeorectifyConfiguration
implements ApplicationListener {
    private static final Logger LOGGER = Logging.getLogger(GeorectifyConfiguration.class);
    private static final String GDAL_CONFIG_FILE = "gdalops.properties";
    Resource configFile;
    Timer timer;
    private static final String SYSTEM_TEMP_DIR = System.getProperty("java.io.tmpdir");
    private File tempFolder;
    private File loggingFolder;
    private long executionTimeout = GRDefaults.EXECUTION_TIMEOUT;
    private Map<String, String> envVariables;
    private String gdalWarpingParameters = "-co TILED=yes -wm 64 -multi -dstalpha";
    private String gdalTranslateParameters = "";
    private String warpingCommand = "gdalwarp";
    private String translateCommand = "gdal_translate";

    public GeorectifyConfiguration() {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        this.configFile = loader.get(GDAL_CONFIG_FILE);
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new ConfigurationPoller(), 1000L);
    }

    private void loadConfiguration() {
        block4: {
            try {
                if (this.configFile.getType() == Resource.Type.RESOURCE) {
                    this.loadConfig();
                } else {
                    this.tempFolder = this.initFolder(GRDefaults.TEMP_DIR);
                    this.loggingFolder = this.initFolder(GRDefaults.LOGGING_DIR);
                }
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, "Unable to configure some of the GeorectifyCoverage process properties.", e);
            }
        }
    }

    private void loadConfig() throws IOException {
        block20: {
            boolean hasPropertiesFile;
            boolean bl = hasPropertiesFile = this.configFile != null && this.configFile.getType() == Resource.Type.RESOURCE;
            if (hasPropertiesFile) {
                Properties props = new Properties();
                try (InputStream fis = this.configFile.in();){
                    props.load(fis);
                    Iterator<Object> keys = props.keySet().iterator();
                    this.envVariables = Maps.newHashMap();
                    while (keys.hasNext()) {
                        String param;
                        String key = (String)keys.next();
                        if (key.equalsIgnoreCase("GDAL_CACHEMAX")) {
                            String cacheMax = null;
                            try {
                                cacheMax = (String)props.get("GDAL_CACHEMAX");
                                if (cacheMax == null) continue;
                                this.envVariables.put("GDAL_CACHEMAX", cacheMax);
                            }
                            catch (NumberFormatException nfe) {
                                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                                LOGGER.log(Level.WARNING, "Unable to parse the specified property as a number: " + cacheMax, nfe);
                            }
                            continue;
                        }
                        if (key.equalsIgnoreCase("GDAL_DATA") || key.equalsIgnoreCase("GDAL_LOGGING_DIR") || key.equalsIgnoreCase("TEMP_DIR")) {
                            String path = (String)props.get(key);
                            if (path == null) continue;
                            File directory = new File(path);
                            if (directory.exists() && directory.isDirectory() && (key.equalsIgnoreCase("GDAL_DATA") && directory.canRead() || directory.canWrite())) {
                                this.envVariables.put(key, path);
                                continue;
                            }
                            if (!LOGGER.isLoggable(Level.WARNING)) continue;
                            LOGGER.log(Level.WARNING, "The specified folder for " + key + " variable isn't valid, or it doesn't exist or it isn't a readable directory or it is a destination folder which can't be written: " + path);
                            continue;
                        }
                        if (key.equalsIgnoreCase("EXECUTION_TIMEOUT")) {
                            String timeout = null;
                            try {
                                timeout = (String)props.get("EXECUTION_TIMEOUT");
                                if (timeout == null) continue;
                                this.executionTimeout = Long.parseLong(timeout);
                            }
                            catch (NumberFormatException nfe) {
                                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                                LOGGER.log(Level.WARNING, "Unable to parse the specified property as a number: " + timeout, nfe);
                            }
                            continue;
                        }
                        if (key.equalsIgnoreCase("GDAL_WARP_PARAMS") || key.equalsIgnoreCase("GDAL_TRANSLATE_PARAMS")) {
                            param = (String)props.get(key);
                            if (param == null) continue;
                            if (key.equalsIgnoreCase("GDAL_WARP_PARAMS")) {
                                this.gdalWarpingParameters = param.trim();
                                continue;
                            }
                            this.gdalTranslateParameters = param.trim();
                            continue;
                        }
                        if (!key.endsWith("PATH") || (param = (String)props.get(key)) == null) continue;
                        this.envVariables.put(key, param);
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block20;
                    LOGGER.log(Level.WARNING, "Unable to parse the config file: " + this.configFile.path(), e);
                }
            }
        }
    }

    private File initFolder(String folderPath) throws IOException {
        File tempFolder = new File(folderPath);
        if (!tempFolder.exists()) {
            boolean createdFolder;
            block5: {
                createdFolder = false;
                try {
                    createdFolder = tempFolder.mkdir();
                }
                catch (SecurityException se) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                    LOGGER.warning("Unable to create the specified folder: " + folderPath + "\nProceeding with using the System temp folder: " + SYSTEM_TEMP_DIR);
                }
            }
            if (!createdFolder) {
                tempFolder = new File(SYSTEM_TEMP_DIR);
            }
        }
        if (!tempFolder.exists() || !tempFolder.canWrite()) {
            throw new IOException("Unable to write on the specified folder: " + tempFolder.getAbsolutePath());
        }
        return tempFolder;
    }

    public File getTempFolder() {
        return this.tempFolder;
    }

    public void setTempFolder(File tempFolder) {
        this.tempFolder = tempFolder;
    }

    public File getLoggingFolder() {
        return this.loggingFolder;
    }

    public void setLoggingFolder(File loggingFolder) {
        this.loggingFolder = loggingFolder;
    }

    public long getExecutionTimeout() {
        return this.executionTimeout;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    public void setEnvVariables(Map<String, String> envVariables) {
        this.envVariables = envVariables;
    }

    public String getWarpingCommand() {
        return this.warpingCommand;
    }

    public void setWarpingCommand(String warpingCommand) {
        this.warpingCommand = warpingCommand;
    }

    public String getTranslateCommand() {
        return this.translateCommand;
    }

    public void setTranslateCommand(String translateCommand) {
        this.translateCommand = translateCommand;
    }

    public String getGdalWarpingParameters() {
        return this.gdalWarpingParameters;
    }

    public String getGdalTranslateParameters() {
        return this.gdalTranslateParameters;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            this.timer.cancel();
        }
    }

    private class ConfigurationPoller
    extends TimerTask {
        Long lastModified = null;

        public ConfigurationPoller() {
            this.run();
        }

        @Override
        public void run() {
            long newLastModified = GeorectifyConfiguration.this.configFile.lastmodified();
            if (this.lastModified == null || newLastModified != this.lastModified) {
                this.lastModified = newLastModified;
                GeorectifyConfiguration.this.loadConfiguration();
            }
        }
    }

    static class GRDefaults {
        static final String GDAL_TRANSLATE_COMMAND = "gdal_translate";
        static final String GDAL_WARP_COMMAND = "gdalwarp";
        static final String GDAL_WARPING_PARAMETERS = "-co TILED=yes -wm 64 -multi -dstalpha";
        static final String GDAL_TRANSLATE_PARAMETERS = "";
        static final String TEMP_DIR = SYSTEM_TEMP_DIR;
        static final String LOGGING_DIR = SYSTEM_TEMP_DIR;
        static final Long EXECUTION_TIMEOUT = 180000L;

        GRDefaults() {
        }
    }

    static class GRKeys {
        static final String GDAL_CACHEMAX = "GDAL_CACHEMAX";
        static final String GDAL_DATA = "GDAL_DATA";
        static final String GDAL_WARP_PARAMS = "GDAL_WARP_PARAMS";
        static final String GDAL_TRANSLATE_PARAMS = "GDAL_TRANSLATE_PARAMS";
        static final String GDAL_LOGGING_DIR = "GDAL_LOGGING_DIR";
        static final String TEMP_DIR = "TEMP_DIR";
        static final String EXECUTION_TIMEOUT = "EXECUTION_TIMEOUT";

        GRKeys() {
        }
    }
}

