/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.IOException;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.gs.GeoServerProcess;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.filter.Filter;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;

@DescribeProcess(title="GetFullCoverage", description="Returns a raster from the catalog, with optional filtering")
public class GetFullCoverage
implements GeoServerProcess {
    private Catalog catalog;

    public GetFullCoverage(Catalog catalog) {
        this.catalog = catalog;
    }

    @DescribeResult(name="result", description="Output raster", type=GridCoverage2D.class)
    public GridCoverage2D execute(@DescribeParameter(name="name", description="Name of raster, optionally fully qualified (workspace:name)") String name, @DescribeParameter(name="filter", description="Filter to use on the raster data", min=0) Filter filter) throws IOException {
        CoverageInfo ci = this.catalog.getCoverageByName(name);
        if (ci == null) {
            throw new WPSException("Could not find coverage " + name);
        }
        GridCoverageReader reader = ci.getGridCoverageReader(null, null);
        ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
        List parameterDescriptors = readParametersDescriptor.getDescriptor().descriptors();
        GeneralParameterValue[] params = new GeneralParameterValue[]{};
        if (filter != null) {
            params = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])params, (Object)filter, (String[])new String[]{"FILTER", "Filter"});
        }
        return (GridCoverage2D)reader.read(params);
    }
}

