/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.util.Utilities;

public class GridCoverage2DRIA
extends GeometricOpImage {
    public static final BorderExtender DEFAULT_BORDEREXTENDER = BorderExtender.createInstance((int)1);
    private static final Logger LOGGER = Logger.getLogger(GridCoverage2DRIA.class.getName());
    private final GridCoverage2D src;
    private final GridGeometry2D dstGridGeometry;
    private AffineTransform g2wd;
    private AffineTransform g2ws;
    private AffineTransform w2gd;
    private AffineTransform w2gs;
    private MathTransform src2dstCRSTransform;
    private MathTransform dst2srcCRSTransform;
    private byte[][] ctable = null;
    private boolean needReprojection;
    private AffineTransform concatenatedForwardTransform;
    private AffineTransform concatenatedBackwardTransform;
    private int kwidth;
    private int kheight;
    private int maxX;
    private int maxY;
    private RandomIter iter;
    private int lpad;
    private int tpad;
    private int rpad;
    private int bpad;

    public static GridCoverage2DRIA create(GridCoverage2D src, GridCoverage2D dst, double nodata) {
        Utilities.ensureNonNull((String)"dst", (Object)dst);
        return GridCoverage2DRIA.create(src, dst.getGridGeometry(), nodata);
    }

    public static GridCoverage2DRIA create(GridCoverage2D src, GridGeometry2D dstGridGeometry, double nodata) {
        Utilities.ensureNonNull((String)"dstGridGeometry", (Object)dstGridGeometry);
        Utilities.ensureNonNull((String)"src", (Object)src);
        GridEnvelope2D destinationRasterDimension = dstGridGeometry.getGridRange2D();
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setMinX(destinationRasterDimension.x).setMinY(destinationRasterDimension.y);
        imageLayout.setWidth(destinationRasterDimension.width).setHeight(destinationRasterDimension.height);
        imageLayout.setTileHeight(src.getRenderedImage().getSampleModel().getHeight()).setTileWidth(src.getRenderedImage().getSampleModel().getWidth());
        imageLayout.setColorModel(src.getRenderedImage().getColorModel());
        imageLayout.setSampleModel(src.getRenderedImage().getSampleModel());
        BorderExtenderConstant extender = new BorderExtenderConstant(new double[]{nodata});
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, JAI.getDefaultInstance().getTileCache());
        return new GridCoverage2DRIA(src, dstGridGeometry, GridCoverage2DRIA.vectorize((RenderedImage)src.getRenderedImage()), imageLayout, hints, false, (BorderExtender)extender, Interpolation.getInstance((int)0), new double[]{nodata});
    }

    protected GridCoverage2DRIA(GridCoverage2D src, GridGeometry2D dstGridGeometry, Vector sources, ImageLayout layout, Map configuration, boolean cobbleSources, BorderExtender extender, Interpolation interp, double[] nodata) {
        super(sources, layout, configuration, cobbleSources, extender, interp, nodata);
        this.src = src;
        this.dstGridGeometry = new GridGeometry2D((GridGeometry)dstGridGeometry);
        this.initTransformations();
        this.initIterator();
    }

    private void initIterator() {
        if (this.interp != null) {
            this.kwidth = this.interp.getWidth();
            this.kheight = this.interp.getHeight();
            this.lpad = this.interp.getLeftPadding();
            this.rpad = this.interp.getRightPadding();
            this.tpad = this.interp.getTopPadding();
            this.bpad = this.interp.getBottomPadding();
        } else {
            this.bpad = 0;
            this.tpad = 0;
            this.rpad = 0;
            this.lpad = 0;
        }
        if (this.extender == null) {
            this.extender = DEFAULT_BORDEREXTENDER;
        }
        PlanarImage srcImage = PlanarImage.wrapRenderedImage((RenderedImage)this.src.getRenderedImage());
        if (this.lpad != this.rpad || this.rpad != this.tpad || this.tpad != this.bpad || this.bpad != 0) {
            this.minX = srcImage.getMinX();
            this.maxX = srcImage.getMaxX() - 1;
            this.minY = srcImage.getMinY();
            this.maxY = srcImage.getMaxY() - 1;
            Rectangle bounds = new Rectangle(srcImage.getMinX() - this.lpad, srcImage.getMinY() - this.tpad, srcImage.getWidth() + this.lpad + this.rpad, srcImage.getHeight() + this.tpad + this.bpad);
            this.iter = RandomIterFactory.create((Raster)srcImage.getExtendedData(bounds, this.extender), (Rectangle)bounds);
        } else {
            this.minX = srcImage.getMinX();
            this.maxX = srcImage.getMaxX() - 1;
            this.minY = srcImage.getMinY();
            this.maxY = srcImage.getMaxY() - 1;
            this.iter = RandomIterFactory.create((RenderedImage)srcImage, (Rectangle)srcImage.getBounds());
        }
    }

    private void initTransformations() throws IllegalArgumentException {
        this.g2wd = (AffineTransform)this.dstGridGeometry.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        try {
            this.w2gd = this.g2wd.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Can't compute source W2G", e);
        }
        this.g2ws = (AffineTransform)this.src.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        try {
            this.w2gs = this.g2ws.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Can't compute source W2G", e);
        }
        try {
            CoordinateReferenceSystem sourceCRS = this.src.getCoordinateReferenceSystem2D();
            CoordinateReferenceSystem targetCRS = this.dstGridGeometry.getCoordinateReferenceSystem2D();
            if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS)) {
                this.src2dstCRSTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
                this.dst2srcCRSTransform = this.src2dstCRSTransform.inverse();
                if (!this.src2dstCRSTransform.isIdentity()) {
                    this.needReprojection = true;
                    return;
                }
            }
            this.needReprojection = false;
            this.concatenatedForwardTransform = (AffineTransform)this.w2gd.clone();
            this.concatenatedForwardTransform.concatenate(this.g2ws);
            this.concatenatedBackwardTransform = this.concatenatedForwardTransform.createInverse();
            if (XAffineTransform.isIdentity((AffineTransform)this.concatenatedForwardTransform, (double)1.0E-6)) {
                this.concatenatedForwardTransform = new AffineTransform();
                this.concatenatedBackwardTransform = new AffineTransform();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't create a transform between CRS", e);
        }
    }

    public Point2D mapSourcePoint(Point2D srcPt, int sourceIndex) {
        if (srcPt == null) {
            throw new IllegalArgumentException("Bad dest pt");
        }
        if (sourceIndex < 0 || sourceIndex >= this.getNumSources()) {
            throw new IndexOutOfBoundsException("Bad src");
        }
        double[] coords = new double[]{srcPt.getX(), srcPt.getY()};
        try {
            this.mapSourcePoint(coords);
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error transforming coords", e);
            }
            return null;
        }
        Point2D ret = (Point2D)srcPt.clone();
        ret.setLocation(coords[0], coords[1]);
        if (this.dstGridGeometry.getGridRange2D().contains(ret)) {
            return ret;
        }
        LOGGER.log(Level.WARNING, "{0} mapped to {1} lies outside {2},{3}+{4}x{5}", new Object[]{srcPt, ret, this.dstGridGeometry.getGridRange2D().x, this.dstGridGeometry.getGridRange2D().y, this.dstGridGeometry.getGridRange2D().width + this.dstGridGeometry.getGridRange2D().x, this.dstGridGeometry.getGridRange2D().height + this.dstGridGeometry.getGridRange2D().y});
        return null;
    }

    protected Rectangle forwardMapRect(Rectangle pxRect, int i) {
        float[] pts = GridCoverage2DRIA.rect2PointArr(pxRect);
        try {
            this.g2ws.transform(pts, 0, pts, 0, 4);
            this.src2dstCRSTransform.transform(pts, 0, pts, 0, 4);
            this.w2gd.transform(pts, 0, pts, 0, 4);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Error transforming coords", e);
            return null;
        }
        Rectangle srcRect = this.pointArr2Rect(pts);
        return srcRect;
    }

    public Point2D mapDestPoint(Point2D destPt, int sourceIndex) {
        if (destPt == null) {
            throw new IllegalArgumentException("Bad dest pt");
        }
        if (sourceIndex < 0 || sourceIndex >= this.getNumSources()) {
            throw new IndexOutOfBoundsException("Bad src");
        }
        double[] coords = new double[]{destPt.getX(), destPt.getY()};
        try {
            this.mapDestPoint(coords);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Error transforming coords", e);
            return null;
        }
        Point2D ret = (Point2D)destPt.clone();
        ret.setLocation(coords[0], coords[1]);
        if (this.src.getGridGeometry().getGridRange2D().contains(coords[0], coords[1])) {
            return ret;
        }
        return null;
    }

    private void mapDestPoint(double[] coords) throws TransformException {
        int npoints = coords.length / 2;
        if (!this.needReprojection) {
            if (!this.concatenatedBackwardTransform.isIdentity()) {
                this.concatenatedBackwardTransform.transform(coords, 0, coords, 0, npoints);
            }
            return;
        }
        this.g2wd.transform(coords, 0, coords, 0, npoints);
        this.dst2srcCRSTransform.transform(coords, 0, coords, 0, npoints);
        this.w2gs.transform(coords, 0, coords, 0, npoints);
    }

    private void mapSourcePoint(double[] coords) throws TransformException {
        int npoints = coords.length / 2;
        if (!this.needReprojection) {
            if (!this.concatenatedForwardTransform.isIdentity()) {
                this.concatenatedForwardTransform.transform(coords, 0, coords, 0, npoints);
            }
            return;
        }
        this.g2ws.transform(coords, 0, coords, 0, npoints);
        this.src2dstCRSTransform.transform(coords, 0, coords, 0, npoints);
        this.w2gd.transform(coords, 0, coords, 0, npoints);
    }

    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        float[] pts = GridCoverage2DRIA.rect2PointArr(destRect);
        try {
            this.g2wd.transform(pts, 0, pts, 0, 4);
            this.dst2srcCRSTransform.transform(pts, 0, pts, 0, 4);
            this.w2gs.transform(pts, 0, pts, 0, 4);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Error transforming coords", e);
            return null;
        }
        Rectangle pxRect = this.pointArr2Rect(pts);
        return pxRect;
    }

    private static float[] rect2PointArr(Rectangle rect) {
        float dx0 = rect.x;
        float dy0 = rect.y;
        float dw = rect.width;
        float dh = rect.height;
        return new float[]{dx0, dy0, dx0 + dw, dy0, dx0 + dw, dy0 + dh, dx0, dy0 + dh};
    }

    private Rectangle pointArr2Rect(float[] points) {
        float f_sx0 = Float.MAX_VALUE;
        float f_sy0 = Float.MAX_VALUE;
        float f_sx1 = -3.4028235E38f;
        float f_sy1 = -3.4028235E38f;
        for (int i = 0; i < 4; ++i) {
            float px = points[i * 2];
            float py = points[i * 2 + 1];
            f_sx0 = Math.min(f_sx0, px);
            f_sy0 = Math.min(f_sy0, py);
            f_sx1 = Math.max(f_sx1, px);
            f_sy1 = Math.max(f_sy1, py);
        }
        int s_x0 = 0;
        int s_y0 = 0;
        int s_x1 = 0;
        int s_y1 = 0;
        if (this.interp instanceof InterpolationNearest) {
            s_x0 = (int)Math.floor(f_sx0);
            s_y0 = (int)Math.floor(f_sy0);
            s_x1 = (int)Math.ceil((double)f_sx1 + 0.5);
            s_y1 = (int)Math.ceil((double)f_sy1 + 0.5);
        } else {
            s_x0 = (int)Math.floor((double)f_sx0 - 0.5);
            s_y0 = (int)Math.floor((double)f_sy0 - 0.5);
            s_x1 = (int)Math.ceil(f_sx1);
            s_y1 = (int)Math.ceil(f_sy1);
        }
        return new Rectangle(s_x0, s_y0, s_x1 - s_x0, s_y1 - s_y0);
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (d.getDataType()) {
            case 0: {
                this.computeRectByte(sources[0], d);
                break;
            }
            case 1: {
                this.computeRectUShort(sources[0], d);
                break;
            }
            case 2: {
                this.computeRectShort(sources[0], d);
                break;
            }
            case 3: {
                this.computeRectInt(sources[0], d);
                break;
            }
            case 4: {
                this.computeRectFloat(sources[0], d);
                break;
            }
            case 5: {
                this.computeRectDouble(sources[0], d);
            }
        }
        if (d.isDataCopy()) {
            d.clampDataArrays();
            d.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage src, RasterAccessor dst) {
        int minx;
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        int[][] samples = new int[this.kheight][this.kwidth];
        int lineOffset = 0;
        byte[] backgroundByte = new byte[dstBands];
        for (int i = 0; i < dstBands; ++i) {
            backgroundByte[i] = (byte)this.backgroundValues[i];
        }
        if (this.ctable == null) {
            minx = dst.getX();
            int x = 0;
            int miny = dst.getY();
            int y = 0;
            double[] coords = new double[2];
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                y = miny + h;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x = minx + w;
                    try {
                        coords[0] = x;
                        coords[1] = y;
                        this.mapDestPoint(coords);
                    }
                    catch (TransformException e) {
                        LOGGER.log(Level.FINER, e.getMessage(), e);
                        throw new RuntimeException(e);
                    }
                    int xint = GridCoverage2DRIA.floor(coords[0]);
                    int yint = GridCoverage2DRIA.floor(coords[1]);
                    int xfrac = (int)((coords[0] - (double)xint) * (double)precH);
                    int yfrac = (int)((coords[1] - (double)yint) * (double)precV);
                    if (xint < this.minX || xint > this.maxX || yint < this.minY || yint > this.maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = backgroundByte[b];
                            }
                        }
                    } else if (this.interp instanceof InterpolationNearest) {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.iter.getSample(xint, yint, b));
                        }
                    } else {
                        xint -= this.lpad;
                        yint -= this.tpad;
                        for (b = 0; b < dstBands; ++b) {
                            for (int j = 0; j < this.kheight; ++j) {
                                for (int i = 0; i < this.kwidth; ++i) {
                                    samples[j][i] = this.iter.getSample(xint + i, yint + j, b) & 0xFF;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            minx = dst.getX();
            int x = 0;
            int miny = dst.getY();
            int y = 0;
            double[] coords = new double[2];
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                y = miny + h;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x = minx + w;
                    try {
                        coords[0] = x;
                        coords[1] = y;
                        this.mapDestPoint(coords);
                    }
                    catch (TransformException e) {
                        LOGGER.log(Level.FINER, e.getMessage(), e);
                        throw new RuntimeException(e);
                    }
                    int xint = GridCoverage2DRIA.floor(coords[0]);
                    int yint = GridCoverage2DRIA.floor(coords[1]);
                    int xfrac = (int)((coords[0] - (double)xint) * (double)precH);
                    int yfrac = (int)((coords[1] - (double)yint) * (double)precV);
                    if (xint < this.minX || xint >= this.maxX || yint < this.minY || yint >= this.maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = backgroundByte[b];
                            }
                        }
                    } else {
                        xint -= this.lpad;
                        yint -= this.tpad;
                        for (b = 0; b < dstBands; ++b) {
                            byte[] t = this.ctable[b];
                            for (int j = 0; j < this.kheight; ++j) {
                                for (int i = 0; i < this.kwidth; ++i) {
                                    samples[j][i] = t[this.iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF;
                                }
                            }
                            data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampByte((int)this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
    }

    private void computeRectUShort(PlanarImage src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        int[][] samples = new int[this.kheight][this.kwidth];
        int lineOffset = 0;
        short[] backgroundUShort = new short[dstBands];
        for (int i = 0; i < dstBands; ++i) {
            backgroundUShort[i] = (short)this.backgroundValues[i];
        }
        int minx = dst.getX();
        int x = 0;
        int miny = dst.getY();
        int y = 0;
        double[] coords = new double[2];
        for (int h = 0; h < dstHeight; ++h) {
            int pixelOffset = lineOffset;
            lineOffset += lineStride;
            y = miny + h;
            for (int w = 0; w < dstWidth; ++w) {
                int b;
                x = minx + w;
                try {
                    coords[0] = x;
                    coords[1] = y;
                    this.mapDestPoint(coords);
                }
                catch (TransformException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                    throw new RuntimeException(e);
                }
                int xint = GridCoverage2DRIA.floor(coords[0]);
                int yint = GridCoverage2DRIA.floor(coords[1]);
                int xfrac = (int)((coords[0] - (double)xint) * (double)precH);
                int yfrac = (int)((coords[1] - (double)yint) * (double)precV);
                if (xint < this.minX || xint > this.maxX || yint < this.minY || yint > this.maxY) {
                    if (this.setBackground) {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = backgroundUShort[b];
                        }
                    }
                } else if (this.interp instanceof InterpolationNearest) {
                    for (b = 0; b < dstBands; ++b) {
                        data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampUShort((int)this.iter.getSample(xint, yint, b));
                    }
                } else {
                    xint -= this.lpad;
                    yint -= this.tpad;
                    for (b = 0; b < dstBands; ++b) {
                        for (int j = 0; j < this.kheight; ++j) {
                            for (int i = 0; i < this.kwidth; ++i) {
                                samples[j][i] = this.iter.getSample(xint + i, yint + j, b) & 0xFFFF;
                            }
                        }
                        data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampUShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                    }
                }
                pixelOffset += pixelStride;
            }
        }
    }

    private void computeRectShort(PlanarImage src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        int[][] samples = new int[this.kheight][this.kwidth];
        int lineOffset = 0;
        short[] backgroundShort = new short[dstBands];
        for (int i = 0; i < dstBands; ++i) {
            backgroundShort[i] = (short)this.backgroundValues[i];
        }
        int minx = dst.getX();
        int x = 0;
        int miny = dst.getY();
        int y = 0;
        double[] coords = new double[2];
        for (int h = 0; h < dstHeight; ++h) {
            int pixelOffset = lineOffset;
            lineOffset += lineStride;
            y = miny + h;
            for (int w = 0; w < dstWidth; ++w) {
                int b;
                x = minx + w;
                try {
                    coords[0] = x;
                    coords[1] = y;
                    this.mapDestPoint(coords);
                }
                catch (TransformException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                    throw new RuntimeException(e);
                }
                int xint = GridCoverage2DRIA.floor(coords[0]);
                int yint = GridCoverage2DRIA.floor(coords[1]);
                int xfrac = (int)((coords[0] - (double)xint) * (double)precH);
                int yfrac = (int)((coords[1] - (double)yint) * (double)precV);
                if (xint < this.minX || xint > this.maxX || yint < this.minY || yint > this.maxY) {
                    if (this.setBackground) {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = backgroundShort[b];
                        }
                    }
                } else if (this.interp instanceof InterpolationNearest) {
                    for (b = 0; b < dstBands; ++b) {
                        data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampShort((int)this.iter.getSample(xint, yint, b));
                    }
                } else {
                    xint -= this.lpad;
                    yint -= this.tpad;
                    for (b = 0; b < dstBands; ++b) {
                        for (int j = 0; j < this.kheight; ++j) {
                            for (int i = 0; i < this.kwidth; ++i) {
                                samples[j][i] = this.iter.getSample(xint + i, yint + j, b);
                            }
                        }
                        data[b][pixelOffset + bandOffsets[b]] = ImageUtil.clampShort((int)this.interp.interpolate(samples, xfrac, yfrac));
                    }
                }
                pixelOffset += pixelStride;
            }
        }
    }

    private void computeRectInt(PlanarImage src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        int[][] samples = new int[this.kheight][this.kwidth];
        int lineOffset = 0;
        int[] backgroundInt = new int[dstBands];
        for (int i = 0; i < dstBands; ++i) {
            backgroundInt[i] = (int)this.backgroundValues[i];
        }
        int minx = dst.getX();
        int x = 0;
        int miny = dst.getY();
        int y = 0;
        double[] coords = new double[2];
        for (int h = 0; h < dstHeight; ++h) {
            int pixelOffset = lineOffset;
            lineOffset += lineStride;
            y = miny + h;
            for (int w = 0; w < dstWidth; ++w) {
                int b;
                x = minx + w;
                try {
                    coords[0] = x;
                    coords[1] = y;
                    this.mapDestPoint(coords);
                }
                catch (TransformException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                    throw new RuntimeException(e);
                }
                int xint = GridCoverage2DRIA.floor(coords[0]);
                int yint = GridCoverage2DRIA.floor(coords[1]);
                int xfrac = (int)((coords[0] - (double)xint) * (double)precH);
                int yfrac = (int)((coords[1] - (double)yint) * (double)precV);
                if (xint < this.minX || xint > this.maxX || yint < this.minY || yint > this.maxY) {
                    if (this.setBackground) {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = backgroundInt[b];
                        }
                    }
                } else if (this.interp instanceof InterpolationNearest) {
                    for (b = 0; b < dstBands; ++b) {
                        data[b][pixelOffset + bandOffsets[b]] = this.iter.getSample(xint, yint, b);
                    }
                } else {
                    xint -= this.lpad;
                    yint -= this.tpad;
                    for (b = 0; b < dstBands; ++b) {
                        for (int j = 0; j < this.kheight; ++j) {
                            for (int i = 0; i < this.kwidth; ++i) {
                                samples[j][i] = this.iter.getSample(xint + i, yint + j, b);
                            }
                        }
                        data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                    }
                }
                pixelOffset += pixelStride;
            }
        }
    }

    private void computeRectFloat(PlanarImage src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        float[][] dstData = dst.getFloatDataArrays();
        float[][] samples = new float[this.kheight][this.kwidth];
        int lineOffset = 0;
        int minx = dst.getX();
        int x = 0;
        int miny = dst.getY();
        int y = 0;
        double[] coords = new double[2];
        for (int h = 0; h < dstHeight; ++h) {
            int pixelOffset = lineOffset;
            lineOffset += dstLineStride;
            y = miny + h;
            for (int w = 0; w < dstWidth; ++w) {
                int b;
                x = minx + w;
                try {
                    coords[0] = x;
                    coords[1] = y;
                    this.mapDestPoint(coords);
                }
                catch (TransformException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                    throw new RuntimeException(e);
                }
                int xint = GridCoverage2DRIA.floor(coords[0]);
                int yint = GridCoverage2DRIA.floor(coords[1]);
                float xfrac = (float)(coords[0] - (double)xint);
                float yfrac = (float)(coords[1] - (double)yint);
                if (xint < this.minX || xint > this.maxX || yint < this.minY || yint > this.maxY) {
                    if (this.setBackground) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][pixelOffset + dstBandOffsets[b]] = (float)this.backgroundValues[b];
                        }
                    }
                } else if (this.interp instanceof InterpolationNearest) {
                    for (b = 0; b < dstBands; ++b) {
                        dstData[b][pixelOffset + dstBandOffsets[b]] = this.iter.getSampleFloat(xint, yint, b);
                    }
                } else {
                    xint -= this.lpad;
                    yint -= this.tpad;
                    for (b = 0; b < dstBands; ++b) {
                        for (int j = 0; j < this.kheight; ++j) {
                            for (int i = 0; i < this.kwidth; ++i) {
                                samples[j][i] = this.iter.getSampleFloat(xint + i, yint + j, b);
                            }
                        }
                        dstData[b][pixelOffset + dstBandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                    }
                }
                pixelOffset += dstPixelStride;
            }
        }
    }

    private void computeRectDouble(PlanarImage src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        double[][] samples = new double[this.kheight][this.kwidth];
        int lineOffset = 0;
        int minx = dst.getX();
        int x = 0;
        int miny = dst.getY();
        int y = 0;
        double[] coords = new double[2];
        for (int h = 0; h < dstHeight; ++h) {
            int pixelOffset = lineOffset;
            lineOffset += lineStride;
            y = miny + h;
            for (int w = 0; w < dstWidth; ++w) {
                int b;
                x = minx + w;
                try {
                    coords[0] = x;
                    coords[1] = y;
                    this.mapDestPoint(coords);
                }
                catch (TransformException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                    throw new RuntimeException(e);
                }
                int xint = GridCoverage2DRIA.floor(coords[0]);
                int yint = GridCoverage2DRIA.floor(coords[1]);
                float xfrac = (float)(coords[0] - (double)xint);
                float yfrac = (float)(coords[1] - (double)yint);
                if (xint < this.minX || xint > this.maxX || yint < this.minY || yint > this.maxY) {
                    if (this.setBackground) {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                        }
                    }
                } else if (this.interp instanceof InterpolationNearest) {
                    for (b = 0; b < dstBands; ++b) {
                        data[b][pixelOffset + bandOffsets[b]] = this.iter.getSampleDouble(xint, yint, b);
                    }
                } else {
                    xint -= this.lpad;
                    yint -= this.tpad;
                    for (b = 0; b < dstBands; ++b) {
                        for (int j = 0; j < this.kheight; ++j) {
                            for (int i = 0; i < this.kwidth; ++i) {
                                samples[j][i] = this.iter.getSampleDouble(xint + i, yint + j, b);
                            }
                        }
                        data[b][pixelOffset + bandOffsets[b]] = this.interp.interpolate(samples, xfrac, yfrac);
                    }
                }
                pixelOffset += pixelStride;
            }
        }
    }

    private static final int floor(double f) {
        return f >= 0.0 ? (int)f : (int)f - 1;
    }

    public float[] warpSparseRect(int x0, int y0, int width, int height, int periodX, int periodY, float[] destRect) {
        if (destRect == null) {
            destRect = new float[(width + periodX - 1) / periodX * ((height + periodY - 1) / periodY) * 2];
        }
        width += x0;
        height += y0;
        int index = 0;
        double[] xy = new double[2];
        for (int y = y0; y < height; y += periodY) {
            for (int x = x0; x < width; x += periodX) {
                xy[0] = x;
                xy[1] = y;
                try {
                    this.mapSourcePoint(xy);
                    destRect[index++] = (float)xy[0];
                    destRect[index++] = (float)xy[1];
                    continue;
                }
                catch (TransformException e) {
                    LOGGER.log(Level.WARNING, "Error transforming {0}", (Object)xy);
                    destRect[index++] = Float.NaN;
                    destRect[index++] = Float.NaN;
                }
            }
        }
        return destRect;
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.iter != null) {
            this.iter.done();
        }
        JAI.getDefaultInstance().getTileCache().removeTiles((RenderedImage)((Object)this));
    }
}

