/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.wps.gs.GeoServerProcess;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.util.logging.Logging;

@DescribeProcess(title="PagedUnique", description="Gets the list of unique values for the given featurecollection on a specified field, allows optional paging")
public class PagedUniqueProcess
implements GeoServerProcess {
    private static final Logger LOGGER = Logging.getLogger(PagedUniqueProcess.class);
    private final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @DescribeResult(name="result", type=Results.class, description="List of values")
    public Results execute(@DescribeParameter(name="features", min=1, max=1, description="Layer from which field values should be retrieved") SimpleFeatureCollection features, @DescribeParameter(name="fieldName", min=1, max=1, description="Field from which the values should be retrieved") String fieldName, @DescribeParameter(name="startIndex", min=0, max=1, description="The index of the first feature to retrieve") Integer startIndex, @DescribeParameter(name="maxFeatures", min=0, max=1, description="The maximum numbers of features to fetch") Integer maxFeatures) throws IOException, CQLException {
        if (features == null) {
            throw new IllegalArgumentException("features param cannot be null");
        }
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Empty or null fieldName provided!");
        }
        SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
        String featureTypeName = featureType.getTypeName();
        LOGGER.fine("PagedUnique process called on resource: " + featureTypeName + " - field: " + fieldName);
        UniqueVisitor visitor = new UniqueVisitor(new Expression[]{this.FF.property(fieldName)}){

            public boolean hasLimits() {
                return true;
            }
        };
        visitor.setPreserveOrder(true);
        Integer listSize = 0;
        List<Object> list = new ArrayList();
        try {
            features.accepts((FeatureVisitor)visitor, null);
            if (visitor.getResult() == null || this.visitorAsList(visitor) == null) {
                listSize = 0;
                list = new ArrayList(0);
            } else {
                listSize = this.visitorAsList(visitor).size();
                if (maxFeatures == null || maxFeatures > listSize) {
                    maxFeatures = listSize;
                }
                visitor.reset();
                if (startIndex != null) {
                    visitor.setStartIndex(startIndex.intValue());
                }
                if (maxFeatures != null) {
                    visitor.setMaxFeatures(maxFeatures.intValue());
                }
                features.accepts((FeatureVisitor)visitor, null);
                list = visitor.getResult() == null || this.visitorAsList(visitor) == null ? new ArrayList(0) : this.visitorAsList(visitor);
            }
            return new Results(featureTypeName, fieldName, listSize, list);
        }
        catch (Exception e) {
            throw new ProcessException("Error extracting unique values", (Throwable)e);
        }
    }

    private List<String> visitorAsList(UniqueVisitor visitor) {
        return visitor.getResult().toList();
    }

    public static final class Results {
        private String featureTypeName;
        private String fieldName;
        private int size;
        private List<?> values;

        public Results(String featureTypeName, String fieldName, int size, List<?> values) {
            this.featureTypeName = featureTypeName;
            this.fieldName = fieldName;
            this.size = size;
            this.values = values;
        }

        public String getFeatureTypeName() {
            return this.featureTypeName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getSize() {
            return this.size;
        }

        public List<?> getValues() {
            return this.values;
        }
    }
}

