/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.media.jai.ROI;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.gs.GeoServerProcess;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.DateRange;
import org.geotools.util.DateTimeParser;
import org.geotools.util.logging.Logging;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.media.jai.zonalstats.ZonalStatsOpImage;
import org.jaitools.numeric.Statistic;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

@DescribeProcess(title="SpatioTemporal Zonal statistics", description="Compute aggregated zonal statistics on a multi-temporal coverage")
public class SpatioTemporalZonalStatistics
implements GeoServerProcess {
    private static final String DESCRIPTION = "A feature collection containing aggregated statistics for each zone.  The process will iterate over the specified times and aggregate the requested stats for the zone. Aggregation is made by computing the min of the mins, the max of the maxes, the sum of the sums,  the mean of the means, and the mean of the medians.";
    private static final Integer[] BAND_STAT = new Integer[]{0};
    public static final int MAX_TIME_ENTRIES = Integer.parseInt(System.getProperty("spatio.temporal.max.entries", "1000"));
    private static final EnumSet<Statistic> ALLOWED_STATS = EnumSet.of(Statistic.MIN, Statistic.MAX, Statistic.SUM, Statistic.MEAN, Statistic.MEDIAN);
    static final Logger LOGGER = Logging.getLogger(SpatioTemporalZonalStatistics.class);
    private Catalog catalog;
    private DateTimeParser timeParser = new DateTimeParser(MAX_TIME_ENTRIES);

    public SpatioTemporalZonalStatistics(Catalog catalog) {
        this.catalog = catalog;
    }

    @DescribeResult(name="result", description="A feature collection containing aggregated statistics for each zone.  The process will iterate over the specified times and aggregate the requested stats for the zone. Aggregation is made by computing the min of the mins, the max of the maxes, the sum of the sums,  the mean of the means, and the mean of the medians.", type=SimpleFeatureCollection.class)
    public SimpleFeatureCollection execute(@DescribeParameter(name="layerName", description="Input layer name of a multi-temporal raster") String layerName, @DescribeParameter(name="timeValues", description="Time values over which the statistics should be computed. Either a comma separated list of values or a temporal range") String times, @DescribeParameter(name="zones", description="Zone polygon features for which to compute statistics") SimpleFeatureCollection zones, @DescribeParameter(name="statsNames", description="Comma separated list of requested statistics within this set (min/max/sum/mean/median). Compute all statistics if not specified", min=0) String statsNames) throws ProcessException {
        GridCoverage2DReader reader;
        Set<Statistic> requestedStats = SpatioTemporalZonalStatistics.parseStatistics(statsNames);
        LayerInfo layer = this.catalog.getLayerByName(layerName);
        if (layer == null) {
            throw new ProcessException("Layer '" + layerName + "' not found in catalog.");
        }
        if (!(layer.getResource() instanceof CoverageInfo)) {
            throw new ProcessException("Layer '" + layerName + "' is not a coverage resource.");
        }
        CoverageInfo coverage = (CoverageInfo)layer.getResource();
        try {
            reader = (GridCoverage2DReader)coverage.getGridCoverageReader(null, null);
        }
        catch (IOException e) {
            throw new ProcessException("Unable to obtain a reader for layer: " + layerName, (Throwable)e);
        }
        if (reader == null) {
            throw new ProcessException("Unable to obtain a reader for layer: " + layerName);
        }
        List<Object> timeDomain = this.parseTimes(reader, times);
        return new SpatioTemporalZonalStatisticsCollection(reader, zones, timeDomain, requestedStats);
    }

    private static GridGeometry2D getGridGeometry(ReferencedEnvelope geometryEnvelope, AffineTransform sourceGridToWorldTransform) throws TransformException {
        MathTransform2D gridToWorld = (MathTransform2D)sourceGridToWorldTransform;
        MathTransform2D worldToGrid = gridToWorld.inverse();
        Envelope gridEnvelope = JTS.transform((Envelope)geometryEnvelope, (MathTransform)worldToGrid);
        int minX = (int)Math.floor(gridEnvelope.getMinX());
        int maxX = (int)Math.ceil(gridEnvelope.getMaxX());
        int minY = (int)Math.floor(gridEnvelope.getMinY());
        int maxY = (int)Math.ceil(gridEnvelope.getMaxY());
        int width = maxX - minX;
        int height = maxY - minY;
        GridEnvelope2D gridRange = new GridEnvelope2D(minX, minY, width, height);
        return new GridGeometry2D((GridEnvelope)gridRange, (Bounds)geometryEnvelope);
    }

    private static double getStatsValue(ZonalStats zonalStats, Statistic statistic) {
        return ((Result)zonalStats.statistic(statistic).results().get(0)).getValue();
    }

    private static Set<Statistic> parseStatistics(String statsNames) throws WPSException {
        String[] tokens;
        HashSet<Statistic> requestedStats = new HashSet<Statistic>();
        if (statsNames == null || statsNames.trim().isEmpty()) {
            requestedStats.addAll(ALLOWED_STATS);
            return requestedStats;
        }
        for (String token : tokens = statsNames.split(",")) {
            String statName = token.trim().toUpperCase();
            try {
                Statistic stat = Statistic.valueOf((String)statName);
                if (!ALLOWED_STATS.contains(stat)) {
                    throw new WPSException("Statistic not allowed: " + statName, "InvalidParameterValue", statsNames);
                }
                requestedStats.add(stat);
            }
            catch (IllegalArgumentException e) {
                WPSException wpse = new WPSException("Unknown statistic: " + statName, "InvalidParameterValue", statsNames);
                wpse.initCause(e);
                throw wpse;
            }
        }
        return requestedStats;
    }

    private List<Object> parseTimes(GridCoverage2DReader reader, String timeValues) throws ProcessException {
        LOGGER.fine("Retrieving timeDomain for the specified timeValues: " + timeValues);
        if (timeValues == null || timeValues.trim().isEmpty()) {
            throw new WPSException("Time parameter cannot be null or empty", "InvalidParameterValue", timeValues);
        }
        try {
            Collection parsed = this.timeParser.parse(timeValues);
            List<Object> timeDomain = parsed.stream().collect(Collectors.toList());
            if (timeDomain.size() == 1 && timeDomain.get(0) instanceof DateRange) {
                timeDomain = SpatioTemporalZonalStatistics.parseTimeRange(reader, (DateRange)timeDomain.get(0));
            }
            return timeDomain;
        }
        catch (IOException | ParseException e) {
            throw new ProcessException("Error retrieving the temporal domain", (Throwable)e);
        }
    }

    private static List<Object> parseTimeRange(GridCoverage2DReader reader, DateRange dateRange) throws IOException {
        ReaderDimensionsAccessor dimensionsAccessor = new ReaderDimensionsAccessor(reader);
        TreeSet timeDomain = dimensionsAccessor.getTimeDomain(dateRange, MAX_TIME_ENTRIES);
        if (timeDomain == null || timeDomain.isEmpty()) {
            throw new ProcessException("No entries have been found in the specified dateRange: " + dateRange);
        }
        return new ArrayList<Object>(timeDomain);
    }

    static class SpatioTemporalZonalStatisticsIterator
    implements SimpleFeatureIterator {
        private final List<Object> times;
        private GridCoverage2DReader reader;
        private SimpleFeatureIterator zones;
        private SimpleFeatureBuilder builder;
        private SimpleFeature nextFeature;
        private Set<Statistic> requestedStats;

        public SpatioTemporalZonalStatisticsIterator(SimpleFeatureIterator zones, GridCoverage2DReader reader, SimpleFeatureType targetSchema, List<Object> times, Set<Statistic> requestedStats) {
            this.zones = zones;
            this.builder = new SimpleFeatureBuilder(targetSchema);
            this.reader = reader;
            this.requestedStats = requestedStats;
            this.times = times;
        }

        public void close() {
            this.zones.close();
        }

        public boolean hasNext() {
            if (this.nextFeature != null) {
                return true;
            }
            if (!this.zones.hasNext()) {
                return false;
            }
            if (this.zones.hasNext()) {
                SimpleFeature zone = (SimpleFeature)this.zones.next();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Next feature zone is: " + zone);
                }
                try {
                    StatisticsAggregator stats;
                    Geometry zoneGeom = (Geometry)zone.getDefaultGeometry();
                    CoordinateReferenceSystem dataCrs = this.reader.getCoordinateReferenceSystem();
                    CoordinateReferenceSystem zonesCrs = this.builder.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem();
                    if (!CRS.equalsIgnoreMetadata((Object)zonesCrs, (Object)dataCrs)) {
                        zoneGeom = JTS.transform((Geometry)zoneGeom, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)zonesCrs, (CoordinateReferenceSystem)dataCrs, (boolean)true));
                    }
                    if ((stats = this.processStatistics(zoneGeom)) != null) {
                        this.builder.addAll(zone.getAttributes());
                        this.addStatsToFeature(stats, this.requestedStats);
                    } else {
                        this.builder.addAll(zone.getAttributes());
                    }
                    this.nextFeature = this.builder.buildFeature(zone.getID());
                    return true;
                }
                catch (Exception e) {
                    throw new ProcessException("Failed to compute statistics on feature " + zone, (Throwable)e);
                }
            }
            return false;
        }

        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SimpleFeature result = this.nextFeature;
            this.nextFeature = null;
            return result;
        }

        private void addStatsToFeature(StatisticsAggregator stats, Set<Statistic> requestedStats) {
            double count = stats.getAggregatedCount();
            this.builder.add((Object)count);
            this.addDynamicStatsToFeature(this.builder, stats, requestedStats);
        }

        private void addDynamicStatsToFeature(SimpleFeatureBuilder builder, StatisticsAggregator stats, Set<Statistic> requestedStats) {
            if (requestedStats.contains(Statistic.MIN)) {
                builder.add((Object)stats.getAggregatedMin());
            }
            if (requestedStats.contains(Statistic.MAX)) {
                builder.add((Object)stats.getAggregatedMax());
            }
            if (requestedStats.contains(Statistic.SUM)) {
                builder.add((Object)stats.getAggregatedSum());
            }
            if (requestedStats.contains(Statistic.MEAN)) {
                builder.add((Object)stats.getAggregatedMean());
            }
            if (requestedStats.contains(Statistic.MEDIAN)) {
                builder.add((Object)stats.getAggregatedMedian());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StatisticsAggregator processStatistics(Geometry geometry) throws TransformException, IOException {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Starting statistics aggregation on geometry: " + geometry);
            }
            List noDataValueRangeList = null;
            ROI roi = null;
            ParameterValue timeParam = AbstractGridFormat.TIME.createValue();
            Statistic[] reqStatsArr = this.requestedStats.toArray(new Statistic[0]);
            StatisticsAggregator aggregator = new StatisticsAggregator(this.requestedStats);
            boolean initialized = false;
            CoordinateReferenceSystem crs = this.reader.getCoordinateReferenceSystem();
            ReferencedEnvelope geometryEnvelope = null;
            ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            for (Object temporalItem : this.times) {
                if (temporalItem instanceof Date) {
                    Date time = (Date)temporalItem;
                    LOGGER.fine("Computing stat for time: " + time);
                    timeParam.setValue(Collections.singletonList(time));
                } else if (temporalItem instanceof DateRange) {
                    DateRange range = (DateRange)temporalItem;
                    LOGGER.fine("Computing stat for time: " + range);
                    timeParam.setValue(Collections.singletonList(range));
                } else {
                    throw new IllegalArgumentException("Unsupported temporal item: " + temporalItem);
                }
                GridCoverage2D dataCoverage = null;
                GridCoverage2D cropped = null;
                try {
                    GeneralParameterValue[] gpv;
                    if (!initialized) {
                        geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), crs);
                        ReferencedEnvelope nativeEnvelope = new ReferencedEnvelope((Bounds)this.reader.getOriginalEnvelope());
                        AffineTransform gridToWorld = this.getGridToWorld(this.reader, nativeEnvelope);
                        double resX = Math.abs(gridToWorld.getScaleX());
                        double resY = Math.abs(gridToWorld.getScaleY());
                        geometryEnvelope.expandBy(resX, resY);
                        if (!nativeEnvelope.intersects((Envelope)geometryEnvelope)) {
                            StatisticsAggregator statisticsAggregator = null;
                            return statisticsAggregator;
                        }
                        if (!nativeEnvelope.contains((Envelope)geometryEnvelope)) {
                            geometry = JTS.toGeometry((Envelope)nativeEnvelope).intersection(geometry);
                            geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), crs);
                        }
                        gg.setValue((Object)SpatioTemporalZonalStatistics.getGridGeometry(geometryEnvelope, gridToWorld));
                        gpv = new GeneralParameterValue[]{timeParam, gg};
                        dataCoverage = this.reader.read(gpv);
                        noDataValueRangeList = CoverageUtilities.getNoDataAsList((GridCoverage2D)dataCoverage);
                        roi = CoverageUtilities.getSimplifiedRoiGeometry((GridCoverage2D)dataCoverage, (Geometry)geometry);
                        initialized = true;
                    } else {
                        gpv = new GeneralParameterValue[]{timeParam, gg};
                        dataCoverage = this.reader.read(gpv);
                    }
                    if (dataCoverage == null) {
                        LOGGER.warning("null coverage has been returned for time " + temporalItem + ". Excluding it from the computations");
                        continue;
                    }
                    LOGGER.fine("Cropping the coverage on geometry: " + geometryEnvelope);
                    cropped = CoverageUtilities.crop((GridCoverage2D)dataCoverage, (ReferencedEnvelope)geometryEnvelope);
                    LOGGER.fine("Executing the zonal stat operation");
                    ZonalStatsOpImage zsOp = new ZonalStatsOpImage(cropped.getRenderedImage(), null, null, null, reqStatsArr, BAND_STAT, roi, null, null, null, false, noDataValueRangeList);
                    LOGGER.fine("Aggregating the result");
                    aggregator.aggregate((ZonalStats)zsOp.getProperty("ZonalStatsProperty"));
                }
                finally {
                    if (cropped != null) {
                        cropped.dispose(true);
                    }
                    if (dataCoverage == null) continue;
                    dataCoverage.dispose(true);
                }
            }
            return aggregator;
        }

        private AffineTransform getGridToWorld(GridCoverage2DReader reader, ReferencedEnvelope nativeEnvelope) {
            GridEnvelope nativeGrid = reader.getOriginalGridRange();
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(nativeGrid, (Bounds)nativeEnvelope);
            geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            AffineTransform sourceGridToWorldTransform = geMapper.createAffineTransform();
            return sourceGridToWorldTransform;
        }
    }

    static class SpatioTemporalZonalStatisticsCollection
    extends DecoratingSimpleFeatureCollection {
        private GridCoverage2DReader reader;
        private List<Object> times;
        private SimpleFeatureType targetSchema;
        private Set<Statistic> requestedStats;

        public SpatioTemporalZonalStatisticsCollection(GridCoverage2DReader reader, SimpleFeatureCollection zones, List<Object> times, Set<Statistic> requestedStats) {
            super(zones);
            this.reader = reader;
            this.times = times;
            this.requestedStats = requestedStats;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor att : ((SimpleFeatureType)zones.getSchema()).getAttributeDescriptors()) {
                tb.minOccurs(att.getMinOccurs());
                tb.maxOccurs(att.getMaxOccurs());
                tb.restrictions(att.getType().getRestrictions());
                if (att instanceof GeometryDescriptor) {
                    GeometryDescriptor gatt = (GeometryDescriptor)att;
                    tb.crs(gatt.getCoordinateReferenceSystem());
                }
                tb.add("z_" + att.getLocalName(), att.getType().getBinding());
            }
            SpatioTemporalZonalStatisticsCollection.addAttributes(tb, requestedStats);
            tb.setName(((SimpleFeatureType)zones.getSchema()).getName());
            this.targetSchema = tb.buildFeatureType();
        }

        private static void addAttributes(SimpleFeatureTypeBuilder tb, Set<Statistic> requestedStats) {
            tb.add("count", Long.class);
            if (requestedStats.contains(Statistic.MIN)) {
                tb.add("min", Double.class);
            }
            if (requestedStats.contains(Statistic.MAX)) {
                tb.add("max", Double.class);
            }
            if (requestedStats.contains(Statistic.SUM)) {
                tb.add("sum", Double.class);
            }
            if (requestedStats.contains(Statistic.MEAN)) {
                tb.add("mean", Double.class);
            }
            if (requestedStats.contains(Statistic.MEDIAN)) {
                tb.add("median", Double.class);
            }
        }

        public SimpleFeatureType getSchema() {
            return this.targetSchema;
        }

        public SimpleFeatureIterator features() {
            return new SpatioTemporalZonalStatisticsIterator(this.delegate.features(), this.reader, this.targetSchema, this.times, this.requestedStats);
        }
    }

    static class StatisticsAggregator {
        private Set<Statistic> requestedStats;
        private double aggregatedSum;
        private double aggregatedMean;
        private double aggregatedMin = Double.POSITIVE_INFINITY;
        private double aggregatedMax = Double.NEGATIVE_INFINITY;
        private double aggregatedMedian;
        private int count;
        private int aggregated;

        public StatisticsAggregator(Set<Statistic> requestedStats) {
            this.requestedStats = requestedStats;
        }

        public void aggregate(ZonalStats stats) {
            if (stats == null) {
                return;
            }
            ++this.aggregated;
            this.count = (int)((long)this.count + ((Result)stats.statistic(this.requestedStats.iterator().next()).results().get(0)).getNumAccepted());
            if (this.requestedStats.contains(Statistic.SUM)) {
                this.aggregatedSum += SpatioTemporalZonalStatistics.getStatsValue(stats, Statistic.SUM);
            }
            if (this.requestedStats.contains(Statistic.MEAN)) {
                this.aggregatedMean += (SpatioTemporalZonalStatistics.getStatsValue(stats, Statistic.MEAN) - this.aggregatedMean) / (double)this.aggregated;
            }
            if (this.requestedStats.contains(Statistic.MIN)) {
                this.aggregatedMin = Math.min(this.aggregatedMin, SpatioTemporalZonalStatistics.getStatsValue(stats, Statistic.MIN));
            }
            if (this.requestedStats.contains(Statistic.MAX)) {
                this.aggregatedMax = Math.max(this.aggregatedMax, SpatioTemporalZonalStatistics.getStatsValue(stats, Statistic.MAX));
            }
            if (this.requestedStats.contains(Statistic.MEDIAN)) {
                this.aggregatedMedian += (SpatioTemporalZonalStatistics.getStatsValue(stats, Statistic.MEDIAN) - this.aggregatedMedian) / (double)this.aggregated;
            }
        }

        public double getAggregatedSum() {
            return this.aggregatedSum;
        }

        public double getAggregatedMean() {
            return this.aggregatedMean;
        }

        public double getAggregatedMin() {
            return this.aggregatedMin;
        }

        public double getAggregatedMax() {
            return this.aggregatedMax;
        }

        public int getAggregated() {
            return this.aggregated;
        }

        public long getAggregatedCount() {
            return this.count;
        }

        public double getAggregatedMedian() {
            return this.aggregatedMedian;
        }
    }
}

