/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wps.gs.GeoServerProcess;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;

@DescribeProcess(title="Store Coverage", description="Stores a raster on the server.")
public class StoreCoverage
implements GeoServerProcess {
    private static final GeoTiffWriteParams DEFAULT_WRITE_PARAMS = new GeoTiffWriteParams();
    WPSResourceManager resources;

    public StoreCoverage(WPSResourceManager resources) {
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DescribeResult(name="coverageLocation", description="URL at which raster can be accessed")
    public URL execute(@DescribeParameter(name="coverage", description="Input raster") GridCoverage2D coverage) throws IOException {
        String fileName = coverage.getName().toString() + ".tif";
        Resource resource = this.resources.getOutputResource(null, fileName);
        ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
        params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)DEFAULT_WRITE_PARAMS);
        GeneralParameterValue[] wps = params.values().toArray(new GeneralParameterValue[1]);
        try (OutputStream os = resource.out();){
            GeoTiffWriter writer = new GeoTiffWriter((Object)os);
            try {
                writer.write((GridCoverage)coverage, wps);
            }
            finally {
                writer.dispose();
            }
        }
        return new URL(this.resources.getOutputResourceUrl(fileName, "image/tiff"));
    }

    static {
        DEFAULT_WRITE_PARAMS.setCompressionMode(2);
        DEFAULT_WRITE_PARAMS.setCompressionType("LZW");
        DEFAULT_WRITE_PARAMS.setCompressionQuality(0.75f);
        DEFAULT_WRITE_PARAMS.setTilingMode(2);
        DEFAULT_WRITE_PARAMS.setTiling(512, 512);
    }
}

