/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.Ows11Factory;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;

public class BoundingBoxPPIO
extends ProcessParameterIO {
    public BoundingBoxPPIO(Class<?> type) {
        super(type, type);
    }

    public Object decode(BoundingBoxType boundingBoxType) throws Exception {
        if (boundingBoxType == null) {
            return null;
        }
        return this.toTargetType(boundingBoxType);
    }

    private Object toTargetType(BoundingBoxType bbox) throws Exception {
        CoordinateReferenceSystem crs = null;
        if (bbox.getCrs() != null) {
            crs = CRS.decode((String)bbox.getCrs());
        }
        double[] lower = this.ordinates(bbox.getLowerCorner());
        double[] upper = this.ordinates(bbox.getUpperCorner());
        if (ReferencedEnvelope.class.isAssignableFrom(this.getType()) || BoundingBox.class.isAssignableFrom(this.getType())) {
            return new ReferencedEnvelope(lower[0], upper[0], lower[1], upper[1], crs);
        }
        if (Envelope.class.isAssignableFrom(this.getType())) {
            return new Envelope(lower[0], upper[0], lower[1], upper[1]);
        }
        if (Bounds.class.isAssignableFrom(this.getType())) {
            GeneralBounds ge = new GeneralBounds(lower, upper);
            ge.setCoordinateReferenceSystem(crs);
            return ge;
        }
        throw new WPSException("Failed to convert from OWS 1.1 Bounding box type to the internal representation: " + this.getType());
    }

    double[] ordinates(List<Double> corner) {
        Double[] objects = corner.toArray(new Double[corner.size()]);
        double[] result = new double[objects.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = objects[i];
        }
        return result;
    }

    public BoundingBoxType encode(Object object) throws WPSException {
        if (object == null) {
            throw new IllegalArgumentException("Cannot encode a null bounding box");
        }
        return this.fromTargetType(object);
    }

    BoundingBoxType fromTargetType(Object object) throws WPSException {
        Envelope env;
        Ows11Factory factory = Ows11Factory.eINSTANCE;
        BoundingBoxType bbox = factory.createBoundingBoxType();
        CoordinateReferenceSystem crs = null;
        if (object instanceof Envelope) {
            env = (Envelope)object;
            if (object instanceof ReferencedEnvelope) {
                ReferencedEnvelope re = (ReferencedEnvelope)object;
                crs = re.getCoordinateReferenceSystem();
            }
            bbox.setLowerCorner(Arrays.asList(env.getMinX(), env.getMinY()));
            bbox.setUpperCorner(Arrays.asList(env.getMaxX(), env.getMaxY()));
        } else if (Bounds.class.isAssignableFrom(this.getType())) {
            env = (Bounds)object;
            crs = env.getCoordinateReferenceSystem();
            bbox.setLowerCorner(this.doubleArrayToList(env.getLowerCorner().getCoordinate()));
            bbox.setUpperCorner(this.doubleArrayToList(env.getUpperCorner().getCoordinate()));
        } else {
            throw new WPSException("Failed to convert from " + object + " to an OWS 1.1 Bounding box type");
        }
        if (crs != null) {
            try {
                bbox.setCrs(ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)false));
            }
            catch (Exception e) {
                throw new WPSException("Could not lookup epsg code for " + crs, e);
            }
        }
        return bbox;
    }

    private List<Double> doubleArrayToList(double[] coordinate) {
        return Arrays.stream(coordinate).boxed().collect(Collectors.toList());
    }
}

