/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wps.ppio.BinaryPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;

public abstract class CoveragePPIO
extends BinaryPPIO {
    private static float DEFAULT_QUALITY = 0.75f;
    private static final Logger LOGGER = Logging.getLogger(CoveragePPIO.class);

    protected CoveragePPIO(String mimeType) {
        super(GridCoverage2D.class, GridCoverage2D.class, mimeType);
    }

    @Override
    public void encode(Object value, OutputStream outputStream) throws Exception {
        this.encode(value, null, outputStream);
    }

    private static float extractQuality(Map<String, Object> encodingParameters) {
        float quality;
        block3: {
            quality = DEFAULT_QUALITY;
            if (encodingParameters != null && !encodingParameters.isEmpty() && encodingParameters.containsKey("quality")) {
                String compressionQuality = (String)encodingParameters.get("quality");
                try {
                    quality = Float.parseFloat(compressionQuality);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block3;
                    LOGGER.info("Specified quality is not valid (it should be in the range [0,1]). quality = " + compressionQuality + "\nUsing default Quality: " + DEFAULT_QUALITY);
                }
            }
        }
        return quality;
    }

    public static class JPEGPPIO
    extends CoveragePPIO {
        public JPEGPPIO() {
            super("image/jpeg");
        }

        @Override
        public void encode(Object value, Map<String, Object> encodingParameters, OutputStream outputStream) throws Exception {
            GridCoverage2D gridCoverage = (GridCoverage2D)value;
            RenderedImage renderedImage = gridCoverage.getRenderedImage();
            ImageWorker worker = new ImageWorker(renderedImage);
            float quality = CoveragePPIO.extractQuality(encodingParameters);
            worker.writeJPEG((Object)outputStream, "JPEG", quality, false);
        }

        @Override
        public String getFileExtension() {
            return "jpeg";
        }

        @Override
        public ProcessParameterIO.PPIODirection getDirection() {
            return ProcessParameterIO.PPIODirection.ENCODING;
        }

        @Override
        public Object decode(InputStream input) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    public static class PNGPPIO
    extends CoveragePPIO {
        public PNGPPIO() {
            super("image/png");
        }

        @Override
        public void encode(Object value, Map<String, Object> encodingParameters, OutputStream outputStream) throws Exception {
            GridCoverage2D gridCoverage = (GridCoverage2D)value;
            RenderedImage renderedImage = gridCoverage.getRenderedImage();
            ImageWorker worker = new ImageWorker(renderedImage);
            float quality = CoveragePPIO.extractQuality(encodingParameters);
            worker.writePNG((Object)outputStream, "FILTERED", quality, false, false);
        }

        @Override
        public String getFileExtension() {
            return "png";
        }

        @Override
        public ProcessParameterIO.PPIODirection getDirection() {
            return ProcessParameterIO.PPIODirection.ENCODING;
        }

        @Override
        public Object decode(InputStream input) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

