/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.ppio.BoundingBoxPPIO;
import org.geoserver.wps.ppio.CQLFilterPPIO;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.CoordinateReferenceSystemPPIO;
import org.geoserver.wps.ppio.EWKTPPIO;
import org.geoserver.wps.ppio.EnumPPIO;
import org.geoserver.wps.ppio.FilterPPIO;
import org.geoserver.wps.ppio.GMLPPIO;
import org.geoserver.wps.ppio.ImagePPIO;
import org.geoserver.wps.ppio.LiteralPPIO;
import org.geoserver.wps.ppio.PPIOFactory;
import org.geoserver.wps.ppio.WFSPPIO;
import org.geoserver.wps.ppio.WKTPPIO;
import org.geotools.api.data.Parameter;
import org.geotools.api.geometry.Bounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.springframework.context.ApplicationContext;

public abstract class ProcessParameterIO {
    static List<ProcessParameterIO> defaults = new ArrayList<ProcessParameterIO>();
    protected final Class<?> externalType;
    protected final Class<?> internalType;
    protected String identifer;

    public static ProcessParameterIO find(Parameter<?> p, ApplicationContext context, String mime) {
        if (p.type.isEnum()) {
            return new EnumPPIO(p.type);
        }
        List<ProcessParameterIO> all = ProcessParameterIO.findAll(p, context);
        if (all.isEmpty()) {
            return null;
        }
        if (mime != null) {
            for (ProcessParameterIO ppio : all) {
                if (!(ppio instanceof ComplexPPIO) || !((ComplexPPIO)ppio).getMimeType().equals(mime)) continue;
                return ppio;
            }
        }
        return all.get(0);
    }

    public static List<ProcessParameterIO> findAll(Parameter<?> p, ApplicationContext context) {
        if (p.type.isEnum()) {
            ArrayList<ProcessParameterIO> result = new ArrayList<ProcessParameterIO>();
            result.add(new EnumPPIO(p.type));
            return result;
        }
        ArrayList<ProcessParameterIO> l = new ArrayList<ProcessParameterIO>(defaults);
        if (context != null) {
            l.addAll(GeoServerExtensions.extensions(ProcessParameterIO.class, (ApplicationContext)context));
        } else {
            l.addAll(GeoServerExtensions.extensions(ProcessParameterIO.class));
        }
        List ppioFactories = context != null ? GeoServerExtensions.extensions(PPIOFactory.class, (ApplicationContext)context) : GeoServerExtensions.extensions(PPIOFactory.class);
        for (PPIOFactory factory : ppioFactories) {
            l.addAll(factory.getProcessParameterIO());
        }
        ArrayList<ProcessParameterIO> matches = new ArrayList<ProcessParameterIO>();
        for (ProcessParameterIO ppio : l) {
            if (ppio.getIdentifer() == null || !ppio.getIdentifer().equals(p.key) || !ProcessParameterIO.typeCompatible(p, ppio)) continue;
            matches.add(ppio);
        }
        if (matches.isEmpty()) {
            for (ProcessParameterIO ppio : l) {
                if (!ProcessParameterIO.typeCompatible(p, ppio)) continue;
                matches.add(ppio);
            }
        }
        return matches;
    }

    private static boolean typeCompatible(Parameter<?> p, ProcessParameterIO ppio) {
        return ppio.getType().isAssignableFrom(p.type);
    }

    private static List<ProcessParameterIO> findByDirection(Parameter<?> p, ApplicationContext context, PPIODirection direction) {
        ArrayList<ProcessParameterIO> ppios = new ArrayList<ProcessParameterIO>();
        List<ProcessParameterIO> matches = ProcessParameterIO.findAll(p, context);
        for (ProcessParameterIO ppio : matches) {
            if (ppio.getDirection() != PPIODirection.BOTH && ppio.getDirection() != direction) continue;
            ppios.add(ppio);
        }
        return ppios;
    }

    public static List<ProcessParameterIO> findEncoder(Parameter<?> p, ApplicationContext context) {
        return ProcessParameterIO.findByDirection(p, context, PPIODirection.ENCODING);
    }

    public static List<ProcessParameterIO> findDecoder(Parameter<?> p, ApplicationContext context) {
        return ProcessParameterIO.findByDirection(p, context, PPIODirection.DECODING);
    }

    public static boolean isComplex(Parameter<?> param, ApplicationContext applicationContext) {
        List<ProcessParameterIO> ppios = ProcessParameterIO.findAll(param, applicationContext);
        if (ppios.isEmpty()) {
            return false;
        }
        return ppios.get(0) instanceof ComplexPPIO;
    }

    protected ProcessParameterIO(Class<?> externalType, Class<?> internalType) {
        this(externalType, internalType, null);
    }

    protected ProcessParameterIO(Class<?> externalType, Class<?> internalType, String identifier) {
        this.externalType = externalType;
        this.internalType = internalType;
        this.identifer = identifier;
    }

    public final Class<?> getExternalType() {
        return this.externalType;
    }

    public final Class<?> getType() {
        return this.internalType;
    }

    public final String getIdentifer() {
        return this.identifer;
    }

    public PPIODirection getDirection() {
        return PPIODirection.BOTH;
    }

    static {
        defaults.add(new LiteralPPIO(BigInteger.class));
        defaults.add(new LiteralPPIO(BigDecimal.class));
        defaults.add(new LiteralPPIO(Double.class));
        defaults.add(new LiteralPPIO(Double.TYPE));
        defaults.add(new LiteralPPIO(Float.class));
        defaults.add(new LiteralPPIO(Float.TYPE));
        defaults.add(new LiteralPPIO(Integer.class));
        defaults.add(new LiteralPPIO(Integer.TYPE));
        defaults.add(new LiteralPPIO(Long.class));
        defaults.add(new LiteralPPIO(Long.TYPE));
        defaults.add(new LiteralPPIO(Short.class));
        defaults.add(new LiteralPPIO(Short.TYPE));
        defaults.add(new LiteralPPIO(Byte.class));
        defaults.add(new LiteralPPIO(Byte.TYPE));
        defaults.add(new LiteralPPIO(Number.class));
        defaults.add(new LiteralPPIO(Boolean.class));
        defaults.add(new LiteralPPIO(Boolean.TYPE));
        defaults.add(new LiteralPPIO(String.class));
        defaults.add(new LiteralPPIO(CharSequence.class));
        defaults.add(new LiteralPPIO(java.util.Date.class));
        defaults.add(new LiteralPPIO(Date.class));
        defaults.add(new LiteralPPIO(Time.class));
        defaults.add(new LiteralPPIO(Timestamp.class));
        defaults.add(new GMLPPIO.GML3.Geometry());
        defaults.add(new GMLPPIO.GML2.Geometry());
        defaults.add(new WKTPPIO());
        defaults.add(new EWKTPPIO());
        defaults.add(new GMLPPIO.GML3.GeometryAlternate());
        defaults.add(new GMLPPIO.GML2.GeometryAlternate());
        defaults.add(new WFSPPIO.WFS10());
        defaults.add(new WFSPPIO.WFS11());
        defaults.add(new WFSPPIO.WFS10Alternate());
        defaults.add(new WFSPPIO.WFS11Alternate());
        defaults.add(new WFSPPIO.WFS20());
        defaults.add(new CoordinateReferenceSystemPPIO());
        defaults.add(new ImagePPIO.PNGPPIO());
        defaults.add(new ImagePPIO.JPEGPPIO());
        defaults.add(new BoundingBoxPPIO(ReferencedEnvelope.class));
        defaults.add(new BoundingBoxPPIO(Bounds.class));
        defaults.add(new BoundingBoxPPIO(Envelope.class));
        defaults.add(new FilterPPIO.Filter10());
        defaults.add(new FilterPPIO.Filter11());
        defaults.add(new CQLFilterPPIO());
    }

    public static enum PPIODirection {
        ENCODING,
        DECODING,
        BOTH;

    }
}

