/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Resource;
import org.geoserver.util.IOUtils;
import org.geoserver.wps.RawDataEncoderDelegate;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.process.RawData;
import org.geoserver.wps.process.ResourceRawData;
import org.geoserver.wps.process.StreamRawData;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.util.logging.Logging;

public class RawDataPPIO
extends ComplexPPIO {
    static final Logger LOGGER = Logging.getLogger(RawDataPPIO.class);
    WPSResourceManager resourceManager;

    protected RawDataPPIO(WPSResourceManager resourceManager) {
        super(RawData.class, RawData.class, "application/octet-stream");
        this.resourceManager = resourceManager;
    }

    @Override
    public Object decode(InputStream input) throws Exception {
        LOGGER.warning("Creating raw data out of a plain input stream, this won't work with asynch requests and won't provide the mime type provided");
        return new StreamRawData("application/octet-stream", input);
    }

    public Object decode(InputStream input, String mimeType, boolean asynchronous) throws Exception {
        if (asynchronous) {
            Resource tmp = this.resourceManager.getTemporaryResource(".bin");
            IOUtils.copy((InputStream)input, (OutputStream)tmp.out(), (int)WPSResourceManager.getCopyBufferSize());
            return new ResourceRawData(tmp, mimeType);
        }
        return new StreamRawData(mimeType, input);
    }

    @Override
    public void encode(Object value, OutputStream os) throws Exception {
        RawData rd = (RawData)value;
        try (InputStream is = rd.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)os, (int)WPSResourceManager.getCopyBufferSize());
        }
    }

    @Override
    public String getFileExtension(Object value) {
        RawData rd = value instanceof RawDataEncoderDelegate ? ((RawDataEncoderDelegate)value).getRawData() : (RawData)value;
        if (rd == null || rd.getFileExtension() == null) {
            return "bin";
        }
        return rd.getFileExtension();
    }
}

