/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.response.ShapeZipOutputFormat;
import org.geoserver.wps.ppio.BinaryPPIO;
import org.geoserver.wps.resource.ShapefileResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public class ShapeZipPPIO
extends BinaryPPIO {
    private static final Logger LOGGER = Logging.getLogger(ShapeZipPPIO.class);
    private final GeoServer gs;
    private final Catalog catalog;
    private final GeoServerResourceLoader resourceLoader;
    WPSResourceManager resources;

    protected ShapeZipPPIO(WPSResourceManager resources, GeoServer gs, Catalog catalog, GeoServerResourceLoader resourceLoader) {
        super(FeatureCollection.class, FeatureCollection.class, "application/zip");
        this.resources = resources;
        this.gs = gs;
        this.catalog = catalog;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void encode(Object value, OutputStream os) throws Exception {
        SimpleFeatureCollection fc = (SimpleFeatureCollection)value;
        ShapeZipOutputFormat of = new ShapeZipOutputFormat(this.gs, this.catalog, this.resourceLoader);
        of.write(Collections.singletonList(fc), this.getCharset(), os, null);
    }

    private Charset getCharset() {
        String charsetName = GeoServerExtensions.getProperty((String)"GS-SHAPEFILE-CHARSET", (ServletContext)null);
        if (charsetName != null) {
            return Charset.forName(charsetName);
        }
        return StandardCharsets.ISO_8859_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(InputStream input) throws Exception {
        ContentFeatureCollection contentFeatureCollection;
        block20: {
            File tempDir;
            block19: {
                tempDir = IOUtils.createTempDirectory((String)"shpziptemp");
                ShapefileResource resource = null;
                try {
                    File shapeFile = null;
                    try (ZipInputStream zis = new ZipInputStream(input);){
                        ZipEntry entry = null;
                        while ((entry = zis.getNextEntry()) != null) {
                            File file = IOUtils.getZipOutputFile((File)tempDir, (ZipEntry)entry);
                            if (entry.isDirectory()) {
                                file.mkdir();
                            } else {
                                if (file.getName().toLowerCase().endsWith(".shp")) {
                                    shapeFile = file;
                                }
                                FileUtils.copyToFile((InputStream)zis, (File)file);
                            }
                            zis.closeEntry();
                        }
                    }
                    if (shapeFile == null) {
                        throw new IOException("Could not find any file with .shp extension in the zip file");
                    }
                    ShapefileDataStore store = new ShapefileDataStore(URLs.fileToUrl(shapeFile));
                    resource = new ShapefileResource(store, tempDir);
                    contentFeatureCollection = store.getFeatureSource().getFeatures();
                    if (resource == null) break block19;
                    this.resources.addResource(resource);
                    break block20;
                }
                catch (Throwable throwable) {
                    if (resource != null) {
                        this.resources.addResource(resource);
                    } else {
                        try {
                            FileUtils.deleteDirectory((File)tempDir);
                        }
                        catch (IOException e) {
                            LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath() + " due to: " + e.getMessage());
                        }
                    }
                    throw throwable;
                }
            }
            try {
                FileUtils.deleteDirectory((File)tempDir);
            }
            catch (IOException e) {
                LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath() + " due to: " + e.getMessage());
            }
        }
        return contentFeatureCollection;
    }

    @Override
    public String getFileExtension() {
        return "zip";
    }
}

