/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.xml.sax.ContentHandler;

public abstract class XMLPPIO
extends ComplexPPIO {
    protected QName element;
    protected volatile EntityResolverProvider resolverProvider;

    protected XMLPPIO(Class<?> externalType, Class<?> internalType, QName element) {
        this(externalType, internalType, "text/xml", element);
    }

    protected XMLPPIO(Class<?> externalType, Class<?> internalType, String mimeType, QName element) {
        super(externalType, internalType, mimeType);
        if (element == null) {
            throw new NullPointerException("element must not be null");
        }
        this.element = element;
    }

    public QName getElement() {
        return this.element;
    }

    public abstract void encode(Object var1, ContentHandler var2) throws Exception;

    @Override
    public void encode(Object value, OutputStream os) throws Exception {
        TransformerHandler serializer = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
        serializer.setResult(new StreamResult(os));
        this.encode(value, serializer);
    }

    @Override
    public String getFileExtension() {
        return "xml";
    }

    protected Parser getParser(Configuration configuration) {
        Parser parser = new Parser(configuration);
        parser.setEntityResolver(this.getResolveProvider().getEntityResolver());
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityResolverProvider getResolveProvider() {
        if (this.resolverProvider == null) {
            XMLPPIO xMLPPIO = this;
            synchronized (xMLPPIO) {
                if (this.resolverProvider == null) {
                    this.resolverProvider = (EntityResolverProvider)GeoServerExtensions.bean(EntityResolverProvider.class);
                }
            }
        }
        return this.resolverProvider;
    }
}

