/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.SaxWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.wps.ppio.XMLPPIO;
import org.xml.sax.ContentHandler;

public class XStreamPPIO
extends XMLPPIO {
    protected XStreamPPIO(Class<?> type, QName element) {
        super(type, type, element);
    }

    protected XStreamPPIO(Class<?> type, String element) {
        super(type, type, new QName(element));
    }

    @Override
    public void encode(Object object, ContentHandler handler) throws Exception {
        SecureXStream xstream = this.buildXStream();
        SaxWriter writer = new SaxWriter();
        writer.setContentHandler(handler);
        xstream.marshal(object, (HierarchicalStreamWriter)writer);
    }

    protected SecureXStream buildXStream() {
        SecureXStream stream = new SecureXStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new UppercaseTagMapper((Mapper)new PackageStrippingMapper((Mapper)next));
            }
        };
        stream.allowTypes(new Class[]{this.getType()});
        return stream;
    }

    @Override
    public Object decode(InputStream input) throws Exception {
        throw new UnsupportedOperationException("XML parsing is not supported");
    }

    protected static class UppercaseTagMapper
    extends MapperWrapper {
        public UppercaseTagMapper(Mapper wrapped) {
            super(wrapped);
        }

        public String serializedMember(Class type, String memberName) {
            char startChar = memberName.charAt(0);
            if (Character.isLowerCase(startChar)) {
                if (memberName.length() > 1) {
                    return Character.toUpperCase(startChar) + memberName.substring(1);
                }
                return String.valueOf(Character.toUpperCase(startChar));
            }
            return memberName;
        }

        public String realMember(Class type, String serialized) {
            String fieldName = super.realMember(type, serialized);
            try {
                type.getDeclaredField(fieldName);
                return fieldName;
            }
            catch (NoSuchFieldException e) {
                char startChar = fieldName.charAt(0);
                if (fieldName.length() > 1) {
                    return Character.toLowerCase(startChar) + fieldName.substring(1);
                }
                return String.valueOf(Character.toLowerCase(startChar));
            }
        }
    }

    protected static class PackageStrippingMapper
    extends MapperWrapper {
        public PackageStrippingMapper(Mapper wrapped) {
            super(wrapped);
        }

        public String serializedClass(Class type) {
            return type.getName().replaceFirst(".*\\.", "");
        }
    }
}

