/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.response;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CodeType;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.LiteralDataType;
import net.opengis.wps10.OutputDataType;
import org.geoserver.ows.Ows11Util;
import org.geoserver.ows.Response;
import org.geoserver.ows.XmlObjectEncodingResponse;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wps.BinaryEncoderDelegate;
import org.geoserver.wps.CDataEncoderDelegate;
import org.geoserver.wps.RawDataEncoderDelegate;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.XMLEncoderDelegate;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.ows.v1_1.OWS;
import org.geotools.ows.v1_1.OWSConfiguration;
import org.geotools.process.ProcessFactory;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.springframework.context.ApplicationContext;

public class ExecuteProcessResponse
extends Response {
    XmlObjectEncodingResponse standardResponse;
    ApplicationContext ctx;

    public ExecuteProcessResponse(Class<?> binding, String elementName, Class<?> xmlConfiguration) {
        super(ExecuteResponseType.class);
        this.standardResponse = new XmlObjectEncodingResponse(binding, elementName, xmlConfiguration);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        if (this.isStandardDocumentResponse(operation)) {
            return this.standardResponse.getMimeType(value, operation);
        }
        ExecuteResponseType response = (ExecuteResponseType)value;
        if (response.getProcessOutputs() == null) {
            return "text/xml";
        }
        OutputDataType result = (OutputDataType)response.getProcessOutputs().getOutput().get(0);
        LiteralDataType literal = result.getData().getLiteralData();
        ComplexDataType complex = result.getData().getComplexData();
        if (literal != null) {
            return "text/plain";
        }
        if (complex != null) {
            return complex.getMimeType();
        }
        return "text/xml";
    }

    private boolean isStandardDocumentResponse(Operation operation) {
        if (operation.getParameters()[0] instanceof ExecuteType) {
            ExecuteType execute = (ExecuteType)operation.getParameters()[0];
            return execute.getResponseForm() == null || execute.getResponseForm().getRawDataOutput() == null;
        }
        return true;
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        String mimeType = this.getMimeType(value, operation);
        String disposition = "inline";
        if (mimeType != null) {
            if (mimeType.indexOf("image") == 0) {
                if (mimeType.indexOf("tiff") > 0) {
                    disposition = "attachment";
                }
            } else if (mimeType.equals("application/zip")) {
                disposition = "attachment";
            } else if (mimeType.equals("application/arcgrid")) {
                disposition = "attachment";
            }
        }
        return disposition;
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        ProcessParameterIO ppio;
        Map resultInfo;
        Parameter p;
        Name name;
        ProcessFactory factory;
        if (this.isStandardDocumentResponse(operation)) {
            return "execute.xml";
        }
        ExecuteResponseType response = (ExecuteResponseType)value;
        if (response.getProcessOutputs() == null) {
            return "execute.xml";
        }
        OutputDataType result = (OutputDataType)response.getProcessOutputs().getOutput().get(0);
        String fname = result.getIdentifier().getValue();
        LiteralDataType literal = result.getData().getLiteralData();
        ComplexDataType complex = result.getData().getComplexData();
        String fext = null;
        if (literal != null) {
            fext = "txt";
        } else if (complex != null && (factory = GeoServerProcessors.createProcessFactory(name = Ows11Util.name((CodeType)response.getProcess().getIdentifier()), true)) != null && (p = (Parameter)(resultInfo = factory.getResultInfo(name, null)).get(result.getIdentifier().getValue())) != null && (ppio = ProcessParameterIO.find(p, this.ctx, complex.getMimeType())) instanceof ComplexPPIO) {
            Object cd = result.getData().getComplexData().getData().get(0);
            fext = ((ComplexPPIO)ppio).getFileExtension(cd);
        }
        if (fext == null) {
            fext = "bin";
        }
        return fname + "." + fext;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        ExecuteResponseType response = (ExecuteResponseType)value;
        if (this.isStandardDocumentResponse(operation) || response.getStatus().getProcessSucceeded() == null) {
            this.standardResponse.write(value, output, operation);
        } else {
            OutputDataType result = (OutputDataType)response.getProcessOutputs().getOutput().get(0);
            LiteralDataType literal = result.getData().getLiteralData();
            BoundingBoxType bbox = result.getData().getBoundingBoxData();
            if (literal != null) {
                this.writeLiteral(output, literal);
            } else if (bbox != null) {
                this.writeBBox(output, bbox);
            } else {
                this.writeComplex(output, result);
            }
        }
    }

    private void writeBBox(OutputStream os, BoundingBoxType bbox) throws IOException {
        Encoder encoder = new Encoder((Configuration)new OWSConfiguration());
        encoder.encode((Object)bbox, OWS.BoundingBox, os);
    }

    void writeComplex(OutputStream output, OutputDataType result) throws IOException {
        Object rawResult = result.getData().getComplexData().getData().get(0);
        if (rawResult instanceof RawDataEncoderDelegate) {
            RawDataEncoderDelegate delegate = (RawDataEncoderDelegate)rawResult;
            delegate.encode(output);
        } else if (rawResult instanceof XMLEncoderDelegate) {
            XMLEncoderDelegate delegate = (XMLEncoderDelegate)rawResult;
            try {
                TransformerHandler xmls = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
                xmls.setResult(new StreamResult(output));
                delegate.encode(xmls);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WPSException("An error occurred while encoding the results of the process", e);
            }
        } else if (rawResult instanceof CDataEncoderDelegate) {
            try {
                ((CDataEncoderDelegate)rawResult).encode(output);
            }
            catch (Exception e) {
                throw new WPSException("An error occurred while encoding the results of the process", e);
            }
        } else if (rawResult instanceof BinaryEncoderDelegate) {
            try {
                ((BinaryEncoderDelegate)rawResult).encode(output);
            }
            catch (Exception e) {
                throw new WPSException("An error occurred while encoding the results of the process", e);
            }
        } else {
            throw new WPSException("Cannot encode an object of class " + rawResult.getClass() + " in raw form");
        }
    }

    void writeLiteral(OutputStream output, LiteralDataType literal) {
        PrintWriter writer = new PrintWriter(output);
        writer.write(literal.getValue());
        writer.flush();
    }
}

