/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.response;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wps.GetExecutionResultType;
import org.geoserver.wps.GetExecutionStatusType;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.resource.WPSResourceManager;

public class StoredResourceResponse
extends Response {
    WPSResourceManager manager;

    public StoredResourceResponse(WPSResourceManager manager) {
        super(Resource.class);
        this.manager = manager;
    }

    public boolean canHandle(Operation operation) {
        String operationId = operation.getId();
        return ("GetExecutionStatus".equalsIgnoreCase(operationId) || "GetExecutionResult".equalsIgnoreCase(operationId)) && operation.getService().getId().equals("wps");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMimeType(Object value, Operation operation) {
        Object request = operation.getParameters()[0];
        if (request instanceof GetExecutionStatusType) {
            return "text/xml";
        }
        if (!(request instanceof GetExecutionResultType)) throw new WPSException("Trying to get a mime type for a unknown operation, we should not have got here in the first place");
        GetExecutionResultType ger = (GetExecutionResultType)request;
        Resource mimeResource = this.manager.getOutputResource(ger.getExecutionId(), ger.getOutputId() + ".mime");
        if (mimeResource == null) throw new WPSException("Unknown output " + ger.getOutputId() + " for execution id " + ger.getExecutionId() + ", either the execution was never submitted or too much time elapsed since the process completed");
        if (mimeResource.getType() == Resource.Type.UNDEFINED) {
            throw new WPSException("Unknown output " + ger.getOutputId() + " for execution id " + ger.getExecutionId() + ", either the execution was never submitted or too much time elapsed since the process completed");
        }
        try (InputStream input = mimeResource.in();){
            String mimeType = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            if (ger.getMimeType() != null) {
                if (!ger.getMimeType().equals(mimeType)) throw new WPSException("Requested mime type does not match the output resource mime type");
            }
            String string = mimeType;
            return string;
        }
        catch (IOException e) {
            throw new WPSException("Error validating the output resource mime type", e);
        }
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        Object request = operation.getParameters()[0];
        if (request instanceof GetExecutionStatusType) {
            return "text/xml";
        }
        if (request instanceof GetExecutionResultType) {
            GetExecutionResultType ger = (GetExecutionResultType)request;
            if (ger.getOutputId() != null) {
                return ger.getOutputId();
            }
            return "result.dat";
        }
        throw new WPSException("Trying to get a file name for a unknown operation, we should not have got here in the first place");
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException {
        Resource resource = (Resource)value;
        try (InputStream is = resource.in();){
            IOUtils.copy((InputStream)is, (OutputStream)output);
        }
    }
}

