/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.security;

import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.SecureTreeNode;
import org.geoserver.wps.security.ProcessAccessLimits;
import org.geoserver.wps.security.ProcessAccessManager;
import org.geoserver.wps.security.WpsAccessRuleDAO;
import org.geotools.api.feature.type.Name;
import org.springframework.security.core.Authentication;

public class DefaultProcessAccessManager
implements ProcessAccessManager {
    private WpsAccessRuleDAO dao;
    long lastLoaded = Long.MIN_VALUE;

    public DefaultProcessAccessManager(WpsAccessRuleDAO dao) {
        this.dao = dao;
    }

    public CatalogMode getMode() {
        return this.dao.getMode();
    }

    @Override
    public ProcessAccessLimits getAccessLimits(Authentication user, String namespace) {
        SecureTreeNode node = this.dao.getSecurityTreeRoot().getDeepestNode(new String[]{namespace});
        return new ProcessAccessLimits(this.dao.getMode(), node.canAccess(user, AccessMode.READ), namespace);
    }

    @Override
    public ProcessAccessLimits getAccessLimits(Authentication user, Name process) {
        SecureTreeNode node = this.dao.getSecurityTreeRoot().getDeepestNode(new String[]{process.getNamespaceURI(), process.getLocalPart()});
        return new ProcessAccessLimits(this.dao.getMode(), node.canAccess(user, AccessMode.READ), process.toString());
    }
}

