/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.security;

import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ProcessAccessLimits
extends AccessLimits {
    private static final long serialVersionUID = -3253977289877833644L;
    private boolean allowed;
    private String resource;

    public ProcessAccessLimits(CatalogMode mode, boolean allowed, String resource) {
        super(mode);
        this.resource = resource;
        this.allowed = allowed;
    }

    public boolean isAllowed() {
        this.checkCatalogMode();
        return this.allowed;
    }

    private void checkCatalogMode() {
        if (!this.allowed) {
            Request request = (Request)Dispatcher.REQUEST.get();
            CatalogMode mode = this.getMode();
            if (mode == CatalogMode.MIXED) {
                if (request == null || !"GetCapabilities".equalsIgnoreCase(request.getRequest())) {
                    throw ProcessAccessLimits.unauthorizedAccess(this.resource);
                }
            } else if (mode == CatalogMode.CHALLENGE) {
                this.allowed = true;
                if (request != null && !"GetCapabilities".equalsIgnoreCase(request.getRequest()) && ("Execute".equalsIgnoreCase(request.getRequest()) || "DescribeProcess".equalsIgnoreCase(request.getRequest()))) {
                    throw ProcessAccessLimits.unauthorizedAccess(this.resource);
                }
            }
        }
    }

    private static RuntimeException unauthorizedAccess(String resourceName) {
        Authentication user = SecurityContextHolder.getContext().getAuthentication();
        if (user == null || user.getAuthorities().isEmpty()) {
            return new InsufficientAuthenticationException("Cannot access " + resourceName + " as anonymous");
        }
        return new AccessDeniedException("Cannot access " + resourceName + " with the current privileges");
    }
}

