/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.security;

import java.util.logging.Logger;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.process.ProcessFilter;
import org.geoserver.wps.security.DefaultProcessAccessManager;
import org.geoserver.wps.security.ProcessAccessManager;
import org.geoserver.wps.security.SecurityProcessFactory;
import org.geoserver.wps.security.WpsAccessRuleDAO;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityProcessFilter
implements ProcessFilter,
ExtensionPriority {
    protected static final Logger LOGGER = Logging.getLogger(SecurityProcessFilter.class);
    protected ProcessAccessManager manager;

    @Override
    public ProcessFactory filterFactory(ProcessFactory pf) {
        if (this.manager == null) {
            this.manager = (ProcessAccessManager)GeoServerExtensions.bean(ProcessAccessManager.class);
            if (this.manager == null) {
                this.manager = new DefaultProcessAccessManager((WpsAccessRuleDAO)((Object)GeoServerExtensions.bean(WpsAccessRuleDAO.class)));
            }
        }
        return new SecurityProcessFactory(pf, this);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    protected boolean allowProcess(Name processName) {
        Authentication user = SecurityContextHolder.getContext().getAuthentication();
        return this.manager.getAccessLimits(user, processName).isAllowed();
    }
}

