/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class WpsAccessRule
implements Comparable<WpsAccessRule>,
Serializable {
    public static final String ANY = "*";
    public static WpsAccessRule EXECUTE_ALL = new WpsAccessRule("*", "*", "*");
    private String groupName;
    private String wpsName;
    private Set<String> roles;

    public WpsAccessRule(String groupName, String wpsName, Set<String> roles) {
        this.groupName = groupName;
        this.wpsName = wpsName;
        this.roles = roles == null ? new HashSet<String>() : new HashSet<String>(roles);
    }

    public WpsAccessRule(String groupName, String wpsName, String ... roles) {
        this(groupName, wpsName, (Set<String>)(roles == null ? null : new HashSet<String>(Arrays.asList(roles))));
    }

    public WpsAccessRule(WpsAccessRule other) {
        this.groupName = other.groupName;
        this.wpsName = other.wpsName;
        this.roles = new HashSet<String>(other.roles);
    }

    public WpsAccessRule() {
        this(ANY, ANY, new String[0]);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getWpsName() {
        return this.wpsName;
    }

    public void setWpsName(String wpsName) {
        this.wpsName = wpsName;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public String getKey() {
        return this.groupName + "." + this.wpsName;
    }

    public String getValue() {
        if (this.roles.isEmpty()) {
            return ANY;
        }
        StringBuffer sb = new StringBuffer();
        for (String role : this.roles) {
            sb.append(role);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public int compareTo(WpsAccessRule other) {
        int compareGroup = this.compareCatalogItems(this.groupName, other.groupName);
        if (compareGroup != 0) {
            return compareGroup;
        }
        int compareName = this.compareCatalogItems(this.wpsName, other.wpsName);
        return compareName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WpsAccessRule)) {
            return false;
        }
        return 0 == this.compareTo((WpsAccessRule)obj);
    }

    public boolean equalsExact(WpsAccessRule obj) {
        if (0 != this.compareTo(obj)) {
            return false;
        }
        return this.roles.equals(obj.roles);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.groupName).append((Object)this.wpsName).toHashCode();
    }

    public int compareCatalogItems(String item, String otherItem) {
        if (item.equals(otherItem)) {
            return 0;
        }
        if (ANY.equals(item)) {
            return -1;
        }
        if (ANY.equals(otherItem)) {
            return 1;
        }
        return item.compareTo(otherItem);
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

