/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.security;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.SecureTreeNode;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.security.WpsAccessRule;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.util.logging.Logging;

public class WpsAccessRuleDAO
extends ConfigurationListenerAdapter {
    private static final Logger LOGGER = Logging.getLogger(WpsAccessRuleDAO.class);
    static final String WPS_PROP_FILE = "wps.xml";
    private GeoServer gs;
    CatalogMode catalogMode = CatalogMode.HIDE;
    List<WpsAccessRule> rules;
    private SecureTreeNode root;

    public WpsAccessRuleDAO(GeoServer gs) throws IOException {
        this.gs = gs;
        gs.addListener((ConfigurationListener)this);
    }

    public CatalogMode getMode() {
        if (this.root == null) {
            this.loadRules();
        }
        return this.catalogMode;
    }

    public SecureTreeNode getSecurityTreeRoot() {
        if (this.root == null) {
            this.loadRules();
        }
        return this.root;
    }

    protected void loadRules() {
        WPSInfo wps = (WPSInfo)this.gs.getService(WPSInfo.class);
        TreeSet<WpsAccessRule> result = new TreeSet<WpsAccessRule>();
        if (wps != null) {
            this.catalogMode = CatalogMode.HIDE;
            if (wps.getCatalogMode() != null) {
                this.catalogMode = wps.getCatalogMode();
            }
            for (ProcessGroupInfo group : wps.getProcessGroups()) {
                HashSet<String> prefixes = new HashSet<String>();
                ProcessFactory pf = GeoServerProcessors.getProcessFactory(group.getFactoryClass(), false);
                if (pf != null) {
                    Set names = pf.getNames();
                    for (Name name : names) {
                        prefixes.add(name.getNamespaceURI());
                    }
                }
                for (String prefix : prefixes) {
                    if (group.getRoles() == null || group.getRoles().isEmpty()) continue;
                    result.add(new WpsAccessRule(prefix, "*", new HashSet<String>(group.getRoles())));
                }
                for (ProcessInfo process : group.getFilteredProcesses()) {
                    if (process.getRoles() == null || process.getRoles().isEmpty()) continue;
                    result.add(new WpsAccessRule(process.getName().getNamespaceURI(), process.getName().getLocalPart(), new HashSet<String>(process.getRoles())));
                }
            }
        }
        if (result.isEmpty()) {
            result.add(new WpsAccessRule(WpsAccessRule.EXECUTE_ALL));
        }
        this.root = this.buildAuthorizationTree(result);
    }

    private SecureTreeNode buildAuthorizationTree(Collection<WpsAccessRule> rules) {
        SecureTreeNode root = new SecureTreeNode();
        for (WpsAccessRule rule : rules) {
            SecureTreeNode node;
            String group = rule.getGroupName();
            String name = rule.getWpsName();
            if ("*".equals(group)) {
                node = root;
            } else {
                SecureTreeNode ws = root.getChild(group);
                if (ws == null) {
                    ws = root.addChild(group);
                }
                if ("*".equals(name)) {
                    node = ws;
                } else {
                    SecureTreeNode layerNode = ws.getChild(name);
                    if (layerNode == null) {
                        layerNode = ws.addChild(name);
                    }
                    node = layerNode;
                }
            }
            if (node != root) {
                LOGGER.warning("Rule " + rule + " is overriding another rule targetting the same resource");
            }
            node.setAuthorizedRoles(AccessMode.READ, rule.getRoles());
            node.setAuthorizedRoles(AccessMode.WRITE, Collections.singleton("NO_ONE"));
            node.setAuthorizedRoles(AccessMode.ADMIN, Collections.singleton("NO_ONE"));
        }
        root.setAuthorizedRoles(AccessMode.READ, Collections.singleton("*"));
        root.setAuthorizedRoles(AccessMode.WRITE, Collections.singleton("NO_ONE"));
        root.setAuthorizedRoles(AccessMode.ADMIN, Collections.singleton("NO_ONE"));
        return root;
    }

    public void reloaded() {
        this.root = null;
    }

    public void handlePostServiceChange(ServiceInfo service) {
        if (service instanceof WPSInfo) {
            this.root = null;
        }
    }
}

