/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import java.util.Collection;
import org.geoserver.wps.validator.WPSInputValidator;
import org.springframework.validation.Errors;

public class MultiplicityValidator
implements WPSInputValidator {
    private static final long serialVersionUID = 6088321363424263041L;
    static final String CODE = "TooManyValues";
    int maxInstances;

    public MultiplicityValidator(int maxInstances) {
        this.maxInstances = maxInstances;
    }

    public boolean supports(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        int size;
        if (target instanceof Collection && this.maxInstances > 0 && (size = ((Collection)target).size()) > this.maxInstances) {
            errors.reject(CODE, "Input has been provided in too many values, found " + size + " but the maximum accepted amount is " + this.maxInstances);
        }
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int maxInstancens) {
        this.maxInstances = maxInstancens;
    }

    public String toString() {
        return "MultiplicityValidator [maxInstancens=" + this.maxInstances + "]";
    }

    @Override
    public WPSInputValidator copy() {
        return new MultiplicityValidator(this.maxInstances);
    }

    @Override
    public boolean isUnset() {
        return this.maxInstances > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxInstances;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiplicityValidator other = (MultiplicityValidator)obj;
        return this.maxInstances == other.maxInstances;
    }
}

