/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import org.geoserver.wps.validator.WPSInputValidator;
import org.geotools.util.NumberRange;
import org.springframework.validation.Errors;

public class NumberRangeValidator
implements WPSInputValidator {
    private static final long serialVersionUID = 1146580888238281822L;
    static final String CODE = "OutOfRangeValue";
    NumberRange<?> range;

    public NumberRangeValidator(NumberRange<?> range) {
        this.range = range;
    }

    public boolean supports(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.range != null && !this.range.isEmpty() && !this.range.contains((Number)target)) {
            errors.reject(CODE, "Value " + target + " is out of the valid range " + this.range);
        }
    }

    public NumberRange<?> getRange() {
        return this.range;
    }

    public void setRange(NumberRange<?> range) {
        this.range = range;
    }

    public String toString() {
        return "NumberRangeValidator [range=" + this.range + "]";
    }

    @Override
    public WPSInputValidator copy() {
        return new NumberRangeValidator(this.range);
    }

    @Override
    public boolean isUnset() {
        return this.range == null || this.range.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberRangeValidator other = (NumberRangeValidator)obj;
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }
}

