/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import java.util.Collections;
import java.util.List;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.validator.ObjectSizeEstimator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ObjectSizeEstimators
implements ApplicationContextAware {
    private static List<ObjectSizeEstimator> estimators = Collections.emptyList();

    public static long getSizeOf(Object object) {
        for (ObjectSizeEstimator estimator : estimators) {
            long size = estimator.getSizeOf(object);
            if (size <= 0L) continue;
            return size;
        }
        return 0L;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        estimators = GeoServerExtensions.extensions(ObjectSizeEstimator.class, (ApplicationContext)applicationContext);
    }
}

