/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.geoserver.wps.validator.ObjectSizeEstimator;
import org.geotools.coverage.grid.GridCoverage2D;

public class RasterSizeEstimator
implements ObjectSizeEstimator {
    @Override
    public long getSizeOf(Object object) {
        if (object instanceof GridCoverage2D) {
            GridCoverage2D coverage = (GridCoverage2D)object;
            return this.estimateSize(coverage.getRenderedImage());
        }
        if (object instanceof RenderedImage) {
            return this.estimateSize((RenderedImage)object);
        }
        return 0L;
    }

    private long estimateSize(RenderedImage renderedImage) {
        SampleModel sm = renderedImage.getSampleModel();
        int bits = 0;
        for (int ss : sm.getSampleSize()) {
            bits += ss;
        }
        int pixelSizeByte = (int)Math.ceil((double)bits / 8.0);
        return renderedImage.getWidth() * renderedImage.getHeight() * pixelSizeByte;
    }
}

