/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import org.geoserver.wps.WPSException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class ValidationException
extends WPSException {
    private static final long serialVersionUID = 1888292623044848453L;
    private Errors errors;

    public ValidationException(Errors errors, String locator) {
        super(ValidationException.buildMessage(errors));
        this.locator = locator;
        this.errors = errors;
    }

    private static String buildMessage(Errors errors) {
        StringBuilder sb = new StringBuilder("Validation failed for input '").append(errors.getObjectName()).append("': ");
        for (ObjectError error : errors.getGlobalErrors()) {
            sb.append(error.getDefaultMessage());
            sb.append("\n");
        }
        for (ObjectError error : errors.getFieldErrors()) {
            sb.append(error.getField()).append("[").append(error.getDefaultMessage()).append("]");
            sb.append("\n");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public Errors getErrors() {
        return this.errors;
    }
}

