/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.xml.v1_0_0;

import java.io.Reader;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wps.WPSException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.wps.WPSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;

public class WpsXmlReader
extends XmlRequestReader {
    public Logger LOGGER = Logging.getLogger((String)"org.geoserver.wps");
    private WPSConfiguration configuration;
    private EntityResolverProvider resolverProvider;

    public WpsXmlReader(String element, String version, WPSConfiguration configuration, EntityResolverProvider resolverProvider) {
        super(new QName("http://www.opengis.net/wps/1.0.0", element), new Version("1.0.0"), "wps");
        this.configuration = configuration;
        this.resolverProvider = resolverProvider;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Object parsed;
        Parser parser = new Parser((Configuration)this.configuration);
        parser.setValidating(true);
        parser.setEntityResolver(this.resolverProvider.getEntityResolver());
        try {
            parsed = parser.parse(reader);
        }
        catch (Exception e) {
            throw new WPSException("Could not parse XML request.", this.cleanException(e));
        }
        if (!parser.getValidationErrors().isEmpty()) {
            WPSException exception = new WPSException("Invalid request", "InvalidParameterValue");
            for (Exception error : parser.getValidationErrors()) {
                this.LOGGER.warning(error.getLocalizedMessage());
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
        }
        return parsed;
    }
}

