/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.wps.process.ByteArrayRawData;
import org.geoserver.wps.process.RawData;
import org.geoserver.wps.process.StringRawData;
import org.geotools.api.util.InternationalString;
import org.geotools.process.ProcessFactory;
import org.geotools.process.factory.AnnotatedBeanProcessFactory;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.factory.DescribeResults;
import org.geotools.util.SimpleInternationalString;

@DescribeProcess(title="MultiRaw", description="Process used to test processes with multiple raw outputs")
public class MultiRawProcess {
    public static final ProcessFactory getFactory() {
        return new MultiRawProcessFactory();
    }

    @DescribeResults(value={@DescribeResult(name="text", description="Text output", meta={"mimeTypes=text/plain"}, type=RawData.class), @DescribeResult(name="binary", description="Binary output", meta={"mimeTypes=application/zip,image/png", "chosenMimeType=binaryMimeType"}, type=RawData.class), @DescribeResult(name="literal", description="A string", type=String.class)})
    public Map<String, Object> execute(@DescribeParameter(name="id") String id, @DescribeParameter(name="binaryMimeType", min=0) String binaryMimeType) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("literal", id);
        result.put("text", new StringRawData("This is the raw text", "text/plain"));
        result.put("binary", new ByteArrayRawData(new byte[100], binaryMimeType));
        return result;
    }

    private static class MultiRawProcessFactory
    extends AnnotatedBeanProcessFactory {
        public MultiRawProcessFactory() {
            super((InternationalString)new SimpleInternationalString("Multiraw"), "gs", new Class[]{MultiRawProcess.class});
        }
    }
}

