/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.awaitility.Awaitility;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.util.IOUtils;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wps.MonkeyProcess;
import org.geoserver.wps.MultiOutputEchoProcess;
import org.geoserver.wps.MultiRawProcess;
import org.geoserver.wps.process.RawData;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geoserver.wps.xml.WPSConfiguration;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.After;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public abstract class WPSTestSupport
extends GeoServerSystemTestSupport {
    protected static Catalog catalog;
    protected static XpathEngine xp;
    public static String WCS_PREFIX;
    public static String WCS_URI;
    public static QName TASMANIA_DEM;
    public static QName TASMANIA_DEM_NODATA;
    public static QName HOLE;
    public static QName ELSHAPED;
    public static QName RAIN;
    public static QName TASMANIA_BM;
    public static QName ROTATED_CAD;
    public static QName WORLD;
    public static String TIFF;
    List<GridCoverage> coverages = new ArrayList<GridCoverage>();

    protected void setUpInternal(SystemTestData testData) throws Exception {
    }

    protected void setUpNamespaces(Map<String, String> namespaces) {
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setupIAULayers(true, true);
    }

    protected void scheduleForDisposal(GridCoverage coverage) {
        this.coverages.add(coverage);
    }

    @After
    public void disposeCoverages() {
        for (GridCoverage coverage : this.coverages) {
            CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
        }
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        catalog = this.getCatalog();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wps", "http://www.opengis.net/wps/1.0.0");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("feature", this.getFeatureNamespace());
        SystemTestData.registerNamespaces(namespaces);
        this.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xp = XMLUnit.newXpathEngine();
    }

    protected String getFeatureNamespace() {
        return "http://geoserver.sf.net";
    }

    protected void registerNamespaces(Map<String, String> namespaces) {
    }

    protected final void setUpUsers(Properties props) {
    }

    protected final void setUpLayerRoles(Properties properties) {
    }

    protected String root() {
        return "wps?";
    }

    protected void checkValidationErrors(Document dom) throws Exception {
        this.checkValidationErrors(dom, (Configuration)new WPSConfiguration());
    }

    protected void checkValidationErrors(Document dom, Configuration configuration) throws Exception {
        Parser p = new Parser(configuration);
        p.setValidating(true);
        p.parse((Source)new DOMSource(dom));
        if (!p.getValidationErrors().isEmpty()) {
            for (Exception exception : p.getValidationErrors()) {
                SAXParseException ex = (SAXParseException)exception;
                LOGGER.warning(ex.getLineNumber() + "," + ex.getColumnNumber() + " -" + ex.toString());
            }
            Assert.fail((String)"Document did not validate.");
        }
    }

    protected String readFileIntoString(String filename) throws IOException {
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);){
            String string;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(stream));){
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
                string = sb.toString();
            }
            return string;
        }
    }

    public void addWcs11Coverages(SystemTestData testData) throws Exception {
        String styleName = "raster";
        testData.addStyle(styleName, "raster.sld", MockData.class, this.getCatalog());
        HashMap<SystemTestData.LayerProperty, String> props = new HashMap<SystemTestData.LayerProperty, String>();
        props.put(SystemTestData.LayerProperty.STYLE, styleName);
        testData.addRasterLayer(TASMANIA_DEM, "tazdem.tiff", TIFF, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(TASMANIA_DEM_NODATA, "tazdemNoData2.tiff", TIFF, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(HOLE, "hole.zip", null, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(ELSHAPED, "elshaped.zip", null, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(RAIN, "rain.zip", "asc", props, MockData.class, this.getCatalog());
        testData.addRasterLayer(TASMANIA_BM, "tazbm.tiff", TIFF, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(ROTATED_CAD, "rotated.tiff", TIFF, props, MockData.class, this.getCatalog());
        testData.addRasterLayer(WORLD, "world.tiff", TIFF, props, MockData.class, this.getCatalog());
    }

    protected Document submitAsynchronous(String xml, long maxWaitSeconds) throws Exception {
        Document dom = this.postAsDOM("wps", xml);
        XMLAssert.assertXpathExists((String)"//wps:ProcessAccepted", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String fullStatusLocation = xpath.evaluate("//wps:ExecuteResponse/@statusLocation", dom);
        String statusLocation = fullStatusLocation.substring(fullStatusLocation.indexOf(63) - 3);
        return this.waitForProcessEnd(statusLocation, maxWaitSeconds);
    }

    protected Document waitForProcess(String statusLocation, long maxWaitSeconds, ThrowingFunction<Document, Boolean> exitCondition) throws Exception {
        Awaitility.await().atMost(maxWaitSeconds, TimeUnit.SECONDS).until(() -> {
            MockHttpServletResponse response = this.getAsServletResponse(statusLocation);
            String contents = response.getContentAsString();
            if ("".equals(contents)) {
                return false;
            }
            Document dom = this.dom(new ByteArrayInputStream(contents.getBytes()));
            return (Boolean)exitCondition.apply(dom);
        });
        return this.getAsDOM(statusLocation);
    }

    protected Document waitForProcessEnd(String statusLocation, long maxWaitSeconds) throws Exception {
        return this.waitForProcess(statusLocation, maxWaitSeconds, this::executionComplete);
    }

    private boolean executionComplete(Document dom) throws XpathException {
        return this.countMatches(dom, "//wps:Status/wps:ProcessAccepted") == 0 && this.countMatches(dom, "//wps:Status/wps:ProcessStarted") == 0 && this.countMatches(dom, "//wps:Status/wps:ProcessQueued") == 0;
    }

    protected int countMatches(Document d, String xpath) throws XpathException {
        return xp.getMatchingNodes(xpath, d).getLength();
    }

    protected Document waitForProcessStart(String statusLocation, long maxWaitSeconds) throws Exception {
        return this.waitForProcess(statusLocation, maxWaitSeconds, this::executionStarted);
    }

    private boolean executionStarted(Document d) throws XpathException {
        return this.countMatches(d, "//wps:Status/wps:ProcessAccepted") == 0 && this.countMatches(d, "//wps:Status/wps:ProcessQueued") == 0;
    }

    static {
        WCS_PREFIX = "wcs";
        WCS_URI = "http://www.opengis.net/wcs/1.1.1";
        TASMANIA_DEM = new QName(WCS_URI, "DEM", WCS_PREFIX);
        TASMANIA_DEM_NODATA = new QName(WCS_URI, "DEMNODATA", WCS_PREFIX);
        HOLE = new QName(WCS_URI, "hole", WCS_PREFIX);
        ELSHAPED = new QName(WCS_URI, "ElShaped", WCS_PREFIX);
        RAIN = new QName(WCS_URI, "rain", WCS_PREFIX);
        TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
        ROTATED_CAD = new QName(WCS_URI, "RotatedCad", WCS_PREFIX);
        WORLD = new QName(WCS_URI, "World", WCS_PREFIX);
        TIFF = "tiff";
        Processors.addProcessFactory((ProcessFactory)MonkeyProcess.getFactory());
        Processors.addProcessFactory((ProcessFactory)MultiRawProcess.getFactory());
        Processors.addProcessFactory((ProcessFactory)MultiOutputEchoProcess.getFactory());
    }

    public static class AutoDisposableGridCoverage2D
    extends GridCoverage2D
    implements AutoCloseable {
        public AutoDisposableGridCoverage2D(CharSequence name, GridCoverage2D coverage) {
            super(name, coverage);
        }

        @Override
        public void close() {
            CoverageCleanerCallback.disposeCoverage((GridCoverage)this);
        }
    }

    public static class AutoCloseableResource
    implements AutoCloseable {
        WPSResourceManager resourceManager;
        RawData rawData;
        Resource resource;
        File file;

        public File getFile() {
            return this.file;
        }

        public AutoCloseableResource(WPSResourceManager resourceManager, RawData rawData) throws IOException {
            Assert.assertNotNull((Object)rawData);
            this.resourceManager = resourceManager;
            this.rawData = rawData;
            this.resource = resourceManager.getTemporaryResource(rawData.getFileExtension());
            this.file = this.resource.file();
            try (InputStream in = rawData.getInputStream();){
                IOUtils.copy((InputStream)in, (File)this.file);
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.delete((File)this.file, (boolean)true);
            this.resourceManager.finished(this.resourceManager.getExecutionId(Boolean.valueOf(true)));
        }
    }

    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

