/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import javax.xml.namespace.QName;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.MockData;
import org.geoserver.wps.WPSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class AggregateProcessTest
extends WPSTestSupport {
    @Test
    public void testSum() throws Exception {
        String xml = this.aggregateCall("Sum");
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/AggregationResults/*)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-111.0", (String)"/AggregationResults/Sum", (Document)dom);
    }

    @Test
    public void testMin() throws Exception {
        String xml = this.aggregateCall("Min");
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/AggregationResults/*)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-900.0", (String)"/AggregationResults/Min", (Document)dom);
    }

    @Test
    public void testMax() throws Exception {
        String xml = this.aggregateCall("Max");
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/AggregationResults/*)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"300.0", (String)"/AggregationResults/Max", (Document)dom);
    }

    @Test
    public void testAverage() throws Exception {
        String xml = this.aggregateCall("Average");
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/AggregationResults/*)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-22.2", (String)"/AggregationResults/Average", (Document)dom);
    }

    @Test
    public void testStdDev() throws Exception {
        String xml = this.aggregateCall("StdDev");
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/AggregationResults/*)", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((boolean)xpath.evaluate("/AggregationResults/StandardDeviation", dom).matches("442\\.19380.*"));
    }

    @Test
    public void testNonRawOutput() throws Exception {
        String xml = this.aggregateCall("StdDev", false);
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//AggregationResults/*)", (Document)dom);
    }

    private String aggregateCall(String function) {
        return this.aggregateCall(function, true);
    }

    private String aggregateCall(String function, boolean rawOutput) {
        return this.aggregateCall(function, rawOutput, "text/xml", false);
    }

    private String aggregateCall(String function, boolean rawOutput, String mimeType, boolean groupBy) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Aggregate</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"" + this.getWFSQueryLayerId(MockData.PRIMITIVEGEOFEATURE) + "\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>aggregationAttribute</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>intProperty</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>function</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + function + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n";
        if (groupBy) {
            xml = xml + "    <wps:Input>\n      <ows:Identifier>groupByAttributes</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>name</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n";
        }
        xml = xml + "  </wps:DataInputs>\n <wps:ResponseForm>\n";
        xml = rawOutput ? xml + "    <wps:RawDataOutput mimeType=\"" + mimeType + "\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n" : xml + "    <wps:Output mimeType=\"" + mimeType + "\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:Output>\n";
        xml = xml + "  </wps:ResponseForm>\n</wps:Execute>";
        return xml;
    }

    @Test
    public void testAllOneByOne() throws Exception {
        String xml = this.callAll(false);
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(/AggregationResults/*)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-111.0", (String)"/AggregationResults/Sum", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-900.0", (String)"/AggregationResults/Min", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"300.0", (String)"/AggregationResults/Max", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-22.2", (String)"/AggregationResults/Average", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((boolean)xpath.evaluate("/AggregationResults/StandardDeviation", dom).matches("442\\.19380.*"));
    }

    @Test
    public void testAllSinglePass() throws Exception {
        String xml = this.callAll(true);
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(/AggregationResults/*)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-111.0", (String)"/AggregationResults/Sum", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-900.0", (String)"/AggregationResults/Min", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"300.0", (String)"/AggregationResults/Max", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-22.2", (String)"/AggregationResults/Average", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((boolean)xpath.evaluate("/AggregationResults/StandardDeviation", dom).matches("442\\.19380.*"));
    }

    private String callAll(boolean singlePass) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:Aggregate</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>features</ows:Identifier>\n      <wps:Reference mimeType=\"text/xml; subtype=wfs-collection/1.0\" xlink:href=\"http://geoserver/wfs\" method=\"POST\">\n        <wps:Body>\n          <wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\">\n            <wfs:Query typeName=\"" + this.getWFSQueryLayerId(MockData.PRIMITIVEGEOFEATURE) + "\"/>\n          </wfs:GetFeature>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>aggregationAttribute</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>intProperty</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>function</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>Min</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>function</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>Max</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>function</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>Average</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>function</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>Sum</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>function</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>StdDev</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>singlePass</ows:Identifier>\n      <wps:Data>\n        <wps:LiteralData>" + singlePass + "</wps:LiteralData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput>\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
    }

    @Test
    public void testSumAsJson() throws Exception {
        String xml = this.aggregateCall("Sum", true, "application/json", false);
        JSONObject result = this.executeJsonRequest(xml);
        Assert.assertEquals((long)4L, (long)result.size());
        String aggregationAttribute = (String)result.get("AggregationAttribute");
        JSONArray aggregationFunctions = (JSONArray)result.get("AggregationFunctions");
        JSONArray groupByAttributes = (JSONArray)result.get("GroupByAttributes");
        JSONArray aggregationResults = (JSONArray)result.get("AggregationResults");
        Assert.assertEquals((Object)"intProperty", (Object)aggregationAttribute);
        Assert.assertEquals((long)1L, (long)aggregationFunctions.size());
        Assert.assertEquals((Object)"Sum", (Object)aggregationFunctions.get(0));
        Assert.assertEquals((long)0L, (long)groupByAttributes.size());
        Assert.assertEquals((long)1L, (long)aggregationResults.size());
        JSONArray sumResult = (JSONArray)aggregationResults.get(0);
        Assert.assertEquals((long)1L, (long)sumResult.size());
        Assert.assertEquals((Object)sumResult.get(0), (Object)-111);
    }

    @Test
    public void testSumWithGroupBy() throws Exception {
        String xml = this.aggregateCall("Sum", true, "text/xml", true);
        Document dom = this.postAsDOM(this.root(), xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/AggregationResults/*)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(/AggregationResults/GroupByResult/*)", (Document)dom);
    }

    @Test
    public void testSumAsJsonWithGroupBy() throws Exception {
        String xml = this.aggregateCall("Sum", true, "application/json", true);
        JSONObject result = this.executeJsonRequest(xml);
        Assert.assertEquals((long)4L, (long)result.size());
        String aggregationAttribute = (String)result.get("AggregationAttribute");
        JSONArray aggregationFunctions = (JSONArray)result.get("AggregationFunctions");
        JSONArray groupByAttributes = (JSONArray)result.get("GroupByAttributes");
        JSONArray aggregationResults = (JSONArray)result.get("AggregationResults");
        Assert.assertEquals((Object)"intProperty", (Object)aggregationAttribute);
        Assert.assertEquals((long)1L, (long)aggregationFunctions.size());
        Assert.assertEquals((Object)"Sum", (Object)aggregationFunctions.get(0));
        Assert.assertEquals((long)1L, (long)groupByAttributes.size());
        Assert.assertEquals((Object)"name", (Object)groupByAttributes.get(0));
        Assert.assertEquals((long)5L, (long)aggregationResults.size());
    }

    protected JSONObject executeJsonRequest(String wpsRequest) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(this.getWorkspaceAndServicePath(), wpsRequest);
        String content = response.getContentAsString();
        Assert.assertFalse((boolean)content.isEmpty());
        return (JSONObject)this.json(response);
    }

    protected String getWorkspaceAndServicePath() {
        return "wps?";
    }

    protected String getWFSQueryLayerId(QName layerName) {
        return this.getLayerId(layerName);
    }

    public static class LocalWSTest
    extends AggregateProcessTest {
        @Override
        protected String getWorkspaceAndServicePath() {
            return MockData.PRIMITIVEGEOFEATURE.getPrefix() + "/wps?";
        }

        @Override
        protected String root() {
            return MockData.PRIMITIVEGEOFEATURE.getPrefix() + "/wps?";
        }

        @Override
        protected String getWFSQueryLayerId(QName layerName) {
            return layerName.getLocalPart();
        }
    }
}

