/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.util.IOUtils;
import org.geoserver.wps.WPSTestSupport;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class StyleCoverageTest
extends WPSTestSupport {
    static final double EPS = 1.0E-6;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addWcs11Coverages(testData);
    }

    @Test
    public void testStyle() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wps:Execute version=\"1.0.0\" service=\"WPS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd\">\n  <ows:Identifier>gs:StyleCoverage</ows:Identifier>\n  <wps:DataInputs>\n    <wps:Input>\n      <ows:Identifier>coverage</ows:Identifier>\n      <wps:Reference mimeType=\"image/tiff\" xlink:href=\"http://geoserver/wcs\" method=\"POST\">\n        <wps:Body>\n          <wcs:GetCoverage service=\"WCS\" version=\"1.1.1\">\n            <ows:Identifier>" + this.getLayerId(MockData.TASMANIA_DEM) + "</ows:Identifier>\n            <wcs:DomainSubset>\n              <gml:BoundingBox crs=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n                <ows:LowerCorner>-180.0 -90.0</ows:LowerCorner>\n                <ows:UpperCorner>180.0 90.0</ows:UpperCorner>\n              </gml:BoundingBox>\n            </wcs:DomainSubset>\n            <wcs:Output format=\"image/tiff\"/>\n          </wcs:GetCoverage>\n        </wps:Body>\n      </wps:Reference>\n    </wps:Input>\n    <wps:Input>\n      <ows:Identifier>style</ows:Identifier>\n      <wps:Data>\n        <wps:ComplexData mimeType=\"text/xml; subtype=sld/1.0.0\"><![CDATA[<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<StyledLayerDescriptor version=\"1.0.0\" xmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd\">\n  <NamedLayer>\n    <Name>rain</Name>\n    <UserStyle>\n      <Name>rain</Name>\n      <Title>Rain distribution</Title>\n      <FeatureTypeStyle>\n        <Rule>\n          <RasterSymbolizer>\n            <Opacity>1.0</Opacity>\n            <ColorMap>\n              <ColorMapEntry color=\"#FF0000\" quantity=\"0\" />\n              <ColorMapEntry color=\"#FFFFFF\" quantity=\"100\"/>\n              <ColorMapEntry color=\"#00FF00\" quantity=\"2000\"/>\n            </ColorMap>\n          </RasterSymbolizer>\n        </Rule>\n      </FeatureTypeStyle>\n    </UserStyle>\n  </NamedLayer>\n</StyledLayerDescriptor>]]></wps:ComplexData>\n      </wps:Data>\n    </wps:Input>\n  </wps:DataInputs>\n  <wps:ResponseForm>\n    <wps:RawDataOutput mimeType=\"image/tiff\">\n      <ows:Identifier>result</ows:Identifier>\n    </wps:RawDataOutput>\n  </wps:ResponseForm>\n</wps:Execute>";
        MockHttpServletResponse response = this.postAsServletResponse(this.root(), xml);
        Assert.assertEquals((Object)"attachment; filename=result.tiff", (Object)response.getHeader("Content-Disposition"));
        try (ByteArrayInputStream is = this.getBinaryInputStream(response);){
            try (FileOutputStream fos = new FileOutputStream("target/testfile.tiff");){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
            }
            GeoTiffFormat format = new GeoTiffFormat();
            try (FileInputStream fis = new FileInputStream("target/testfile.tiff");){
                GridCoverage2D gc = format.getReader((Object)fis).read(null);
                GridCoverage original = this.getCatalog().getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM)).getGridCoverage(null, null);
                Assert.assertEquals((double)original.getEnvelope().getMinimum(0), (double)gc.getEnvelope().getMinimum(0), (double)1.0E-6);
                Assert.assertEquals((double)original.getEnvelope().getMinimum(1), (double)gc.getEnvelope().getMinimum(1), (double)1.0E-6);
                Assert.assertEquals((double)original.getEnvelope().getMaximum(0), (double)gc.getEnvelope().getMaximum(0), (double)1.0E-6);
                Assert.assertEquals((double)original.getEnvelope().getMaximum(1), (double)gc.getEnvelope().getMaximum(1), (double)1.0E-6);
                Assert.assertTrue((boolean)(gc.getRenderedImage().getColorModel() instanceof IndexColorModel));
                Assert.assertEquals((long)1L, (long)gc.getRenderedImage().getSampleModel().getNumBands());
            }
        }
    }
}

