/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.WPSTestSupport;
import org.geoserver.wps.ppio.CSVPPIO;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CSVPPIOTest
extends WPSTestSupport {
    private InputStream is;
    private WPSResourceManager resourceManager;

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/applicationContext-noargs.xml");
    }

    @Before
    public void prepareInputStream() throws IOException {
        this.resourceManager = (WPSResourceManager)GeoServerExtensions.bean(WPSResourceManager.class);
        this.is = SystemTestData.class.getResourceAsStream("states.csv");
        Assert.assertNotNull((Object)this.is);
    }

    @After
    public void cleanup() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Test
    public void testDecodeInputStream() throws Exception {
        SimpleFeatureCollection states = (SimpleFeatureCollection)new CSVPPIO(this.resourceManager).decode(this.is);
        Assert.assertEquals((String)"Wrong number of states", (long)51L, (long)states.size());
        Assert.assertEquals((String)"Wrong number of columns", (long)9L, (long)((SimpleFeatureType)states.getSchema()).getAttributeCount());
        Filter filter = CQL.toFilter((String)"State = 'Alabama'");
        SimpleFeatureCollection alabama = states.subCollection(filter);
        Assert.assertEquals((String)"inc1995 wrong", (Object)19683, (Object)((SimpleFeature)DataUtilities.first((FeatureCollection)alabama)).getAttribute("inc1995"));
    }

    @Test
    public void testEncodeOutputStream() throws Exception {
        String line;
        SimpleFeatureCollection states = (SimpleFeatureCollection)new CSVPPIO(this.resourceManager).decode(this.is);
        Assert.assertEquals((String)"Wrong number of states", (long)51L, (long)states.size());
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        new CSVPPIO(this.resourceManager).encode((Object)states, (OutputStream)os);
        String csv = os.toString();
        BufferedReader r = new BufferedReader(new StringReader(csv));
        int lines = 0;
        while ((line = r.readLine()) != null) {
            String[] attribs = line.split(",");
            if (lines == 0) {
                Assert.assertEquals((Object)attribs[0], (Object)"State");
                Assert.assertEquals((Object)attribs[1], (Object)"inc1980");
                Assert.assertEquals((Object)attribs[4], (Object)"inc2000");
                Assert.assertEquals((Object)attribs[8], (Object)"inc2012");
            }
            if (attribs[0].equalsIgnoreCase("Tennessee")) {
                Assert.assertEquals((Object)"7711", (Object)attribs[1]);
                Assert.assertEquals((Object)"37678", (Object)attribs[8]);
            }
            ++lines;
        }
        Assert.assertEquals((String)"Wrong number of lines", (long)52L, (long)lines);
    }
}

