/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import org.apache.commons.io.FileUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wps.ppio.CoveragePPIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.image.util.ImageUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoveragePPIOTest {
    File geotiff = new File("./target/testInput.tiff");
    File targetPng = new File("./target/output.png");
    File targetJpeg = new File("./target/output.jpeg");
    GeoTiffReader reader;
    GridCoverage2D coverage;

    @Before
    public void prepareGeoTiff() throws IOException {
        try (InputStream is = SystemTestData.class.getResourceAsStream("tazbm.tiff");){
            FileUtils.copyInputStreamToFile((InputStream)is, (File)this.geotiff);
        }
        this.reader = new GeoTiffReader((Object)this.geotiff);
    }

    @After
    public void cleanup() {
        if (this.coverage != null) {
            ImageUtilities.disposeImage((RenderedImage)this.coverage.getRenderedImage());
        }
        if (this.reader != null) {
            this.reader.dispose();
        }
    }

    private GridCoverage2D getCoverage() throws IOException {
        this.coverage = this.reader.read(null);
        return new GridCoverageFactory().create((CharSequence)this.coverage.getName(), this.coverage.getRenderedImage(), this.coverage.getEnvelope(), this.coverage.getSampleDimensions(), null, null);
    }

    @Test
    public void testPNGEncode() throws Exception {
        GridCoverage2D coverage = this.getCoverage();
        CoveragePPIO.PNGPPIO ppio = new CoveragePPIO.PNGPPIO();
        this.testIsFormat(coverage, (CoveragePPIO)ppio, this.targetPng, "PNG");
    }

    @Test
    public void testJPEGEncode() throws Exception {
        GridCoverage2D coverage = this.getCoverage();
        CoveragePPIO.JPEGPPIO ppio = new CoveragePPIO.JPEGPPIO();
        this.testIsFormat(coverage, (CoveragePPIO)ppio, this.targetJpeg, "JPEG");
    }

    @Test
    public void testEncodeQuality() throws Exception {
        GridCoverage2D coverage = this.getCoverage();
        CoveragePPIO.JPEGPPIO ppio = new CoveragePPIO.JPEGPPIO();
        HashMap<String, String> encodingParams = new HashMap<String, String>();
        File highQualityFile = new File("./target/outputHiQ.jpg");
        encodingParams.put("quality", "0.99");
        try (FileOutputStream fos = new FileOutputStream(highQualityFile);){
            ppio.encode((Object)coverage, encodingParams, (OutputStream)fos);
        }
        long highQualityFileSize = highQualityFile.length();
        File lowQualityFile = new File("./target/outputLoQ.jpg");
        encodingParams.put("quality", "0.01");
        try (FileOutputStream fos = new FileOutputStream(lowQualityFile);){
            ppio.encode((Object)coverage, encodingParams, (OutputStream)fos);
        }
        long lowQualityFileSize = lowQualityFile.length();
        Assert.assertTrue((highQualityFileSize > lowQualityFileSize ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIsFormat(GridCoverage2D coverage, CoveragePPIO ppio, File encodedFile, String formatName) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(encodedFile);){
            ppio.encode((Object)coverage, (OutputStream)fos);
        }
        try (FileImageInputStream fis = new FileImageInputStream(encodedFile);){
            ImageReader imageReader = null;
            try {
                imageReader = ImageIO.getImageReaders(fis).next();
                imageReader.setInput(fis);
                Assert.assertTrue((boolean)formatName.equalsIgnoreCase(imageReader.getFormatName()));
                Assert.assertNotNull((Object)imageReader.read(0));
            }
            finally {
                if (imageReader != null) {
                    try {
                        imageReader.dispose();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

