/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wps.ppio.KMLPPIO;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.io.WKTReader;
import org.w3c.dom.Document;

public class KMLPPIOTest
extends GeoServerTestSupport {
    private XpathEngine xpath;
    private KMLPPIO ppio;

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("", "http://www.topografix.com/GPX/1/1");
        namespaces.put("kml", "http://www.opengis.net/kml/2.2");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.xpath = XMLUnit.newXpathEngine();
    }

    protected void setUpInternal() {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        SettingsInfo settings = global.getSettings();
        ContactInfo contact = settings.getContact();
        contact.setContactOrganization("GeoServer");
        contact.setOnlineResource("http://www.geoserver.org");
        gs.save(global);
        this.ppio = new KMLPPIO(gs, (EntityResolverProvider)GeoServerExtensions.bean(EntityResolverProvider.class));
    }

    @Test
    public void testEncodeLinestring() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.LINES));
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fti.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.ppio.encode((Object)fc, (OutputStream)bos);
        Document dom = this.dom(new ByteArrayInputStream(bos.toByteArray()));
        this.checkValidationErorrs(dom, "./src/test/resources/org/geoserver/wps/ppio/ogckml22.xsd");
        Assert.assertEquals((Object)"-92.99887316950249,4.523788751137377 -92.99842243632469,4.524241087719057", (Object)this.xpath.evaluate("//kml:LineString/kml:coordinates", dom));
        Assert.assertEquals((Object)"t0001 ", (Object)this.xpath.evaluate("//kml:ExtendedData/kml:SchemaData/kml:SimpleData[@name='id']", dom));
    }

    @Test
    public void testEncodePolygon() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fti.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.ppio.encode((Object)fc, (OutputStream)bos);
        Document dom = this.dom(new ByteArrayInputStream(bos.toByteArray()));
        this.checkValidationErorrs(dom, "./src/test/resources/org/geoserver/wps/ppio/ogckml22.xsd");
        Assert.assertEquals((Object)"-1.0,5.0 2.0,5.0 2.0,2.0 -1.0,2.0 -1.0,5.0", (Object)this.xpath.evaluate("//kml:Placemark[@id='BasicPolygons.1107531493644']//kml:LinearRing/kml:coordinates", dom));
    }

    @Test
    public void testEncodePoints() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.POINTS));
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fti.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.ppio.encode((Object)fc, (OutputStream)bos);
        Document dom = this.dom(new ByteArrayInputStream(bos.toByteArray()));
        this.checkValidationErorrs(dom, "./src/test/resources/org/geoserver/wps/ppio/ogckml22.xsd");
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//kml:Placemark", dom).getLength());
        Assert.assertEquals((Object)"t0000", (Object)this.xpath.evaluate("//kml:ExtendedData/kml:SchemaData/kml:SimpleData[@name='id']", dom));
        Assert.assertEquals((Object)"-92.99954926766114,4.52401492058674", (Object)this.xpath.evaluate("//kml:Point/kml:coordinates", dom));
        Assert.assertEquals((Object)"t0000", (Object)this.xpath.evaluate("//kml:ExtendedData/kml:SchemaData/kml:SimpleData[@name='id']", dom));
    }

    @Test
    public void testParsePoi() throws Exception {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("poi.kml");){
            SimpleFeatureCollection pois = (SimpleFeatureCollection)this.ppio.decode(is);
            Assert.assertEquals((long)6L, (long)pois.size());
            SimpleFeature poi = (SimpleFeature)DataUtilities.first((FeatureCollection)pois);
            Assert.assertEquals((Object)new WKTReader().read("POINT(-74.01046109936333 40.707587626256554)"), (Object)poi.getDefaultGeometry());
            Assert.assertEquals((Object)"museam", (Object)poi.getAttribute("NAME"));
            Assert.assertEquals((Object)"pics/22037827-Ti.jpg", (Object)poi.getAttribute("THUMBNAIL"));
            Assert.assertEquals((Object)"pics/22037827-L.jpg", (Object)poi.getAttribute("MAINPAGE"));
        }
    }

    @Test
    public void testDecodeXXE() throws Exception {
        String kml = "<!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:///\" >]><kml><Placemark><name>&xxe;</name></Placemark></kml>";
        Assert.assertNull((Object)this.ppio.decode(kml));
    }
}

