/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.filters.BufferedRequestWrapper;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.util.DimensionWarning;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class RESTIntegrationTest
extends GeoServerSystemTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(false);
    }

    @Test
    public void testReloadConfiguration() throws Exception {
        String path = "/gwc/rest/reload";
        String content = "reload_configuration=1";
        String contentType = "application/x-www-form-urlencoded";
        MockHttpServletResponse response = this.postAsServletResponse(path, content, contentType);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetLayersList() throws Exception {
        String url = "gwc/rest/layers.xml";
        MockHttpServletResponse sr = this.getAsServletResponse("gwc/rest/layers.xml");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertTrue((String)sr.getContentType(), (boolean)sr.getContentType().startsWith("application/xml"));
        Document dom = this.getAsDOM("gwc/rest/layers.xml");
        ArrayList tileLayerNames = Lists.newArrayList((Iterable)GWC.get().getTileLayerNames());
        Collections.sort(tileLayerNames);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext((Map)ImmutableMap.of((Object)"atom", (Object)"http://www.w3.org/2005/Atom")));
        for (String name : tileLayerNames) {
            String xpath = "//layers/layer/name[text() = '" + name + "']";
            XMLAssert.assertXpathExists((String)xpath, (Document)dom);
            xpath = "//layers/layer/atom:link[@href = 'http://localhost:8080/geoserver/gwc/rest/layers/" + name + ".xml']";
            XMLAssert.assertXpathExists((String)xpath, (Document)dom);
        }
    }

    @Test
    public void testGetLayer() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/layers/" + layerName + ".xml";
        String id = this.getCatalog().getLayerByName(layerName).getId();
        MockHttpServletResponse sr = this.getAsServletResponse(url);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertTrue((String)sr.getContentType(), (boolean)sr.getContentType().startsWith("application/xml"));
        Document dom = this.getAsDOM(url);
        XMLAssert.assertXpathExists((String)"/GeoServerLayer", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)id, (String)"/GeoServerLayer/id", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)layerName, (String)"/GeoServerLayer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/GeoServerLayer/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/png", (String)"/GeoServerLayer/mimeFormats/string[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/jpeg", (String)"/GeoServerLayer/mimeFormats/string[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/GeoServerLayer/gridSubsets/gridSubset)", (Document)dom);
        XMLAssert.assertXpathExists((String)"/GeoServerLayer/gridSubsets/gridSubset[gridSetName='EPSG:900913']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/GeoServerLayer/gridSubsets/gridSubset[gridSetName='EPSG:4326']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/GeoServerLayer/autoCacheStyles", (Document)dom);
    }

    @Test
    public void testPutBadId() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, "badId", layerName);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"status", (Matcher)Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentAsString", (Matcher)Matchers.containsString((String)"No GeoServer Layer or LayerGroup exists with id 'badId'")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.startsWith((String)"text/plain")));
    }

    @Test
    public void testPutNoIdBadLayerName() throws Exception {
        String url = "gwc/rest/layers/badLayerName.xml";
        MockHttpServletResponse response = this.putLayer("gwc/rest/layers/badLayerName.xml", "", "badLayerName");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"status", (Matcher)Matchers.equalTo((Object)404)));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentAsString", (Matcher)Matchers.containsString((String)"GeoServer Layer or LayerGroup 'badLayerName' not found")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.startsWith((String)"text/plain")));
    }

    @Test
    public void testPutGoodIdBadLayerName() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/badLayerName.xml";
        MockHttpServletResponse response = this.putLayer("gwc/rest/layers/badLayerName.xml", id, "badLayerName");
        String expected = "Layer with id '" + id + "' found but name does not match: 'badLayerName'/'" + layerName + "'";
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"status", (Matcher)Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentAsString", (Matcher)Matchers.containsString((String)expected)));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.startsWith((String)"text/plain")));
    }

    @Test
    public void testPutGoodIdNoLayerName() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, id, "");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"status", (Matcher)Matchers.equalTo((Object)400)));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentAsString", (Matcher)Matchers.containsString((String)"Layer name not provided")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"contentType", (Matcher)Matchers.startsWith((String)"text/plain")));
    }

    @Test
    public void testPutOverExistingTileLayerSucceeds() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, id, layerName);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testPutBadLayerEndpoint() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        String url = "gwc/rest/layers/badEndpoint.xml";
        MockHttpServletResponse response = this.putLayer("gwc/rest/layers/badEndpoint.xml", id, layerName);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        String expected = "There is a mismatch between the name of the  layer in the submission and the URL you specified.";
        Assert.assertEquals((Object)expected, (Object)response.getContentAsString().substring(response.getContentAsString().indexOf(":") + 1));
    }

    @Test
    public void testPutSuccess() throws Exception {
        String layerName = this.getLayerId(MockData.FORESTS);
        String id = this.getCatalog().getLayerByName(layerName).getId();
        GWC mediator = GWC.get();
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        mediator.removeTileLayers((List)Lists.newArrayList((Object[])new String[]{layerName}));
        Assert.assertFalse((boolean)mediator.tileLayerExists(layerName));
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = this.putLayer(url, id, layerName);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
    }

    @Test
    public void testPutParameterFilters() throws Exception {
        String layerName = this.getLayerId(MockData.LAKES);
        GWC mediator = GWC.get();
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        mediator.removeTileLayers((List)Lists.newArrayList((Object[])new String[]{layerName}));
        Assert.assertFalse((boolean)mediator.tileLayerExists(layerName));
        String xml = "<GeoServerLayer> <enabled>true</enabled> <name>" + layerName + "</name> <mimeFormats><string>image/png8</string></mimeFormats> <gridSubsets>  <gridSubset><gridSetName>GoogleCRS84Quad</gridSetName></gridSubset>  <gridSubset><gridSetName>EPSG:4326</gridSetName></gridSubset> </gridSubsets> <metaWidthHeight><int>9</int><int>6</int></metaWidthHeight> <parameterFilters>  <stringParameterFilter>   <key>BGCOLOR</key>   <defaultValue>0xFFFFFF</defaultValue>   <values><string>0x000000</string><string>0x888888</string></values>  </stringParameterFilter>  <styleParameterFilter>   <key>STYLES</key>   <defaultValue>capital</defaultValue>   <allowedStyles><string>point</string><string>burg</string></allowedStyles>  </styleParameterFilter>  <floatParameterFilter>   <key>ELEVATION</key>   <defaultValue>10.1</defaultValue>    <values>     <float>10.1</float><float>10.2</float><float>10.3</float>    </values>   <threshold>1.0E-2</threshold>  </floatParameterFilter> </parameterFilters> <gutter>20</gutter></GeoServerLayer>";
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.putAsServletResponse(url, xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        Assert.assertEquals((long)20L, (long)info.getGutter());
        Assert.assertEquals((long)2L, (long)tileLayer.getGridSubsets().size());
        Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains("GoogleCRS84Quad"));
        Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains("EPSG:4326"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"image/png8"), (Object)info.getMimeFormats());
        Assert.assertEquals((long)9L, (long)info.getMetaTilingX());
        Assert.assertEquals((long)6L, (long)info.getMetaTilingY());
        ArrayList filters = Lists.newArrayList((Iterable)info.getParameterFilters());
        Assert.assertEquals((long)3L, (long)filters.size());
        FloatParameterFilter floatFilter = null;
        StringParameterFilter stringFilter = null;
        StyleParameterFilter styleFilter = null;
        for (ParameterFilter filter : filters) {
            if (filter instanceof FloatParameterFilter) {
                floatFilter = (FloatParameterFilter)filter;
            }
            if (filter instanceof StringParameterFilter) {
                stringFilter = (StringParameterFilter)filter;
            }
            if (!(filter instanceof StyleParameterFilter)) continue;
            styleFilter = (StyleParameterFilter)filter;
        }
        Assert.assertNotNull(floatFilter);
        Assert.assertNotNull(stringFilter);
        Assert.assertNotNull(styleFilter);
        Assert.assertEquals((Object)"ELEVATION", (Object)floatFilter.getKey());
        Assert.assertEquals((Object)"10.1", (Object)floatFilter.getDefaultValue());
        Assert.assertEquals((double)0.01f, (double)floatFilter.getThreshold().floatValue(), (double)0.0);
        Assert.assertEquals((Object)ImmutableList.of((Object)Float.valueOf(10.1f), (Object)Float.valueOf(10.2f), (Object)Float.valueOf(10.3f)), (Object)floatFilter.getValues());
        Assert.assertEquals((Object)"BGCOLOR", (Object)stringFilter.getKey());
        Assert.assertEquals((Object)"0xFFFFFF", (Object)stringFilter.getDefaultValue());
        Assert.assertEquals((Object)ImmutableList.of((Object)"0x000000", (Object)"0x888888"), (Object)stringFilter.getLegalValues());
        Assert.assertEquals((Object)"STYLES", (Object)styleFilter.getKey());
    }

    @Test
    public void testPutStyleParameterFilter() throws Exception {
        String layerName = this.getLayerId(MockData.LAKES);
        GWC mediator = GWC.get();
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        mediator.removeTileLayers((List)Lists.newArrayList((Object[])new String[]{layerName}));
        Assert.assertFalse((boolean)mediator.tileLayerExists(layerName));
        String xml = "<GeoServerLayer> <enabled>true</enabled> <name>" + layerName + "</name> <mimeFormats><string>image/png8</string></mimeFormats> <gridSubsets>  <gridSubset><gridSetName>GoogleCRS84Quad</gridSetName></gridSubset>  <gridSubset><gridSetName>EPSG:4326</gridSetName></gridSubset> </gridSubsets> <metaWidthHeight><int>9</int><int>6</int></metaWidthHeight> <parameterFilters>  <styleParameterFilter>   <key>STYLES</key>   <defaultValue>capitals</defaultValue>   <allowedStyles><string>points</string><string>bergs</string></allowedStyles>  </styleParameterFilter> </parameterFilters> <gutter>20</gutter></GeoServerLayer>";
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.putAsServletResponse(url, xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        Assert.assertEquals((long)20L, (long)info.getGutter());
        Assert.assertEquals((long)2L, (long)tileLayer.getGridSubsets().size());
        Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains("GoogleCRS84Quad"));
        Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains("EPSG:4326"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"image/png8"), (Object)info.getMimeFormats());
        Assert.assertEquals((long)9L, (long)info.getMetaTilingX());
        Assert.assertEquals((long)6L, (long)info.getMetaTilingY());
        ArrayList filters = Lists.newArrayList((Iterable)info.getParameterFilters());
        Assert.assertEquals((long)1L, (long)filters.size());
        StyleParameterFilter styleFilter = (StyleParameterFilter)filters.get(0);
        Assert.assertEquals((Object)"STYLES", (Object)styleFilter.getKey());
        Assert.assertEquals((Object)"capitals", (Object)styleFilter.getDefaultValue());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"points", (Object)"bergs"), (Object)styleFilter.getStyles());
    }

    private MockHttpServletResponse putLayer(String url, String id, String name) throws Exception {
        String xml = "<GeoServerLayer>  <id>" + id + "</id>  <enabled>true</enabled>  <name>" + name + "</name>  <mimeFormats>    <string>image/jpeg</string>  </mimeFormats>  <gridSubsets>    <gridSubset>     <gridSetName>EPSG:900913</gridSetName>    </gridSubset>    <gridSubset>     <gridSetName>EPSG:4326</gridSetName>    </gridSubset>  </gridSubsets>  <metaWidthHeight>    <int>4</int>    <int>4</int>  </metaWidthHeight>  <autoCacheStyles>true</autoCacheStyles></GeoServerLayer>";
        String contentType = "text/xml";
        MockHttpServletResponse response = super.putAsServletResponse(url, xml, "text/xml");
        return response;
    }

    @Test
    public void testDelete() throws Exception {
        String layerName = this.getLayerId(MockData.BRIDGES);
        GWC mediator = GWC.get();
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.deleteAsServletResponse(url);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)mediator.tileLayerExists(layerName));
    }

    @Test
    public void testDeleteNonExistentLayer() throws Exception {
        String url = "gwc/rest/layers/badLayerName.xml";
        MockHttpServletResponse response = super.deleteAsServletResponse("gwc/rest/layers/badLayerName.xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"Unknown layer: badLayerName", (Object)response.getContentAsString());
    }

    @Test
    public void testPost() throws Exception {
        String layerName = this.getLayerId(MockData.ROAD_SEGMENTS);
        GWC mediator = GWC.get();
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        String xml = "<GeoServerLayer> <enabled>true</enabled> <name>" + layerName + "</name> <mimeFormats><string>image/png8</string></mimeFormats> <gridSubsets>  <gridSubset><gridSetName>GoogleCRS84Quad</gridSetName></gridSubset>  <gridSubset><gridSetName>EPSG:4326</gridSetName></gridSubset> </gridSubsets> <metaWidthHeight><int>9</int><int>6</int></metaWidthHeight> <parameterFilters>  <styleParameterFilter>   <key>STYLES</key>   <defaultValue>capitals</defaultValue>   <allowedStyles><string>burg</string><string>point</string></allowedStyles>  </styleParameterFilter>  <floatParameterFilter>   <key>ELEVATION</key>   <defaultValue>10.1</defaultValue>    <values>     <float>10.1</float><float>10.2</float><float>10.3</float>    </values>   <threshold>1.0E-2</threshold>  </floatParameterFilter> </parameterFilters> <gutter>20</gutter></GeoServerLayer>";
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.postAsServletResponse(url, xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        Assert.assertEquals((long)20L, (long)info.getGutter());
        Assert.assertEquals((long)2L, (long)tileLayer.getGridSubsets().size());
        Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains("GoogleCRS84Quad"));
        Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains("EPSG:4326"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"image/png8"), (Object)info.getMimeFormats());
        Assert.assertEquals((long)9L, (long)info.getMetaTilingX());
        Assert.assertEquals((long)6L, (long)info.getMetaTilingY());
        ArrayList filters = Lists.newArrayList((Iterable)info.getParameterFilters());
        Assert.assertEquals((long)2L, (long)filters.size());
        FloatParameterFilter floatFilter = null;
        StyleParameterFilter styleFilter = null;
        for (ParameterFilter filter : filters) {
            if (filter instanceof FloatParameterFilter) {
                floatFilter = (FloatParameterFilter)filter;
            }
            if (!(filter instanceof StyleParameterFilter)) continue;
            styleFilter = (StyleParameterFilter)filter;
        }
        Assert.assertNotNull(floatFilter);
        Assert.assertNotNull(styleFilter);
        Assert.assertEquals((Object)"ELEVATION", (Object)floatFilter.getKey());
        Assert.assertEquals((Object)"10.1", (Object)floatFilter.getDefaultValue());
        Assert.assertEquals((double)0.01f, (double)floatFilter.getThreshold().floatValue(), (double)0.0);
        Assert.assertEquals((Object)ImmutableList.of((Object)Float.valueOf(10.1f), (Object)Float.valueOf(10.2f), (Object)Float.valueOf(10.3f)), (Object)floatFilter.getValues());
        Assert.assertEquals((Object)"STYLES", (Object)styleFilter.getKey());
        Assert.assertEquals((Object)"capitals", (Object)styleFilter.getDefaultValue());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"burg", (Object)"point"), (Object)styleFilter.getStyles());
    }

    @Test
    public void testPostLegacyAutoStyles() throws Exception {
        String layerName = this.getLayerId(MockData.ROAD_SEGMENTS);
        GWC mediator = GWC.get();
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        String url = "gwc/rest/layers/" + layerName + ".xml";
        String xml = "<GeoServerLayer> <name>" + layerName + "</name> <autoCacheStyles>true</autoCacheStyles></GeoServerLayer>";
        MockHttpServletResponse response = super.postAsServletResponse(url, xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        ArrayList filters = Lists.newArrayList((Iterable)info.getParameterFilters());
        MatcherAssert.assertThat((Object)filters, (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"STYLES")), (Matcher)Matchers.isA(StyleParameterFilter.class.asSubclass(ParameterFilter.class)))));
        xml = "<GeoServerLayer> <name>" + layerName + "</name> <autoCacheStyles>false</autoCacheStyles></GeoServerLayer>";
        response = super.postAsServletResponse(url, xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        info = tileLayer.getInfo();
        filters = Lists.newArrayList((Iterable)info.getParameterFilters());
        MatcherAssert.assertThat((Object)filters, (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"STYLES")), (Matcher)Matchers.isA(StyleParameterFilter.class.asSubclass(ParameterFilter.class))))));
    }

    @Test
    public void testGetSeedHtml() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/seed/" + layerName;
        MockHttpServletResponse sr = this.getAsServletResponse(url);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertTrue((String)sr.getContentType(), (boolean)sr.getContentType().startsWith("text/html"));
    }

    @Test
    public void testPostSeedHtmlForm() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/seed/" + layerName;
        String formData = "threadCount=01&type=seed&gridSetId=EPSG%3A4326&tileFormat=image%2Fpng&zoomStart=00&zoomStop=12&minX=&minY=&maxX=&maxY=";
        MockHttpServletRequest request = this.createRequest(url);
        request.setMethod("POST");
        request.setContentType("application/x-www-form-urlencoded");
        request.setContent("threadCount=01&type=seed&gridSetId=EPSG%3A4326&tileFormat=image%2Fpng&zoomStart=00&zoomStop=12&minX=&minY=&maxX=&maxY=".getBytes(StandardCharsets.UTF_8));
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper((HttpServletRequest)request, "UTF-8", "threadCount=01&type=seed&gridSetId=EPSG%3A4326&tileFormat=image%2Fpng&zoomStart=00&zoomStop=12&minX=&minY=&maxX=&maxY=".getBytes(StandardCharsets.UTF_8));
        MockHttpServletResponse sr = this.dispatch((HttpServletRequest)wrapper);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        this.assertSeedJob(layerName);
    }

    @Test
    public void testGetSeedJson() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/seed/" + layerName + ".json";
        MockHttpServletResponse sr = this.getAsServletResponse(url);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertTrue((String)sr.getContentType(), (boolean)sr.getContentType().startsWith("application/json"));
        JSONObject json = (JSONObject)this.getAsJSON(url);
        Assert.assertNotNull((Object)json.getJSONArray("long-array-array"));
    }

    @Test
    public void testPostSeedXml() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/seed/" + layerName + ".xml";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<seedRequest>\n  <name>" + layerName + "</name>\n  <gridSetId>EPSG:4326</gridSetId>\n  <zoomStart>0</zoomStart>\n  <zoomStop>12</zoomStop>\n  <format>image/png</format>\n  <type>seed</type>\n  <threadCount>1</threadCount>\n</seedRequest>";
        MockHttpServletResponse sr = this.postAsServletResponse(url, xml);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        this.assertSeedJob(layerName);
    }

    @Test
    public void testPostSeedJson() throws Exception {
        String layerName = this.getLayerId(MockData.BASIC_POLYGONS);
        String url = "gwc/rest/seed/" + layerName + ".json";
        String json = "{ \"seedRequest\": {\n  \"name\": \"" + layerName + "\",\n  \"gridSetId\": \"EPSG:4326\",\n  \"zoomStart\": 0,\n  \"zoomStop\": 12,\n  \"type\": \"seed\",\n  \"threadCount\": 1,\n}}";
        MockHttpServletResponse sr = this.postAsServletResponse(url, json);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        this.assertSeedJob(layerName);
    }

    public void assertSeedJob(String layerName) throws Exception {
        String url = "gwc/rest/seed/" + layerName + ".json";
        MockHttpServletResponse sr = this.getAsServletResponse(url);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertTrue((String)sr.getContentType(), (boolean)sr.getContentType().startsWith("application/json"));
        JSONObject json = (JSONObject)this.getAsJSON(url);
        JSONArray jsonArr = json.getJSONArray("long-array-array");
        Assert.assertNotNull((Object)jsonArr);
        Assert.assertFalse((boolean)jsonArr.isEmpty());
    }

    @Test
    public void testPostReloadHtmlForm() throws Exception {
        String url = "gwc/rest/reload";
        String formData = "reload_configuration=1";
        MockHttpServletRequest request = this.createRequest("gwc/rest/reload");
        request.setMethod("POST");
        request.setContentType("application/x-www-form-urlencoded");
        request.setContent("reload_configuration=1".getBytes(StandardCharsets.UTF_8));
        BufferedRequestWrapper wrapper = new BufferedRequestWrapper((HttpServletRequest)request, "UTF-8", "reload_configuration=1".getBytes(StandardCharsets.UTF_8));
        MockHttpServletResponse sr = this.dispatch((HttpServletRequest)wrapper);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
    }

    @Test
    public void testPutWarningSkips() throws Exception {
        String layerName = this.getLayerId(MockData.LAKES);
        GWC mediator = GWC.get();
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        mediator.removeTileLayers((List)Lists.newArrayList((Object[])new String[]{layerName}));
        Assert.assertFalse((boolean)mediator.tileLayerExists(layerName));
        String xml = "<GeoServerLayer> <enabled>true</enabled> <name>" + layerName + "</name> <mimeFormats><string>image/png8</string></mimeFormats> <gridSubsets>  <gridSubset><gridSetName>GoogleCRS84Quad</gridSetName></gridSubset>  <gridSubset><gridSetName>EPSG:4326</gridSetName></gridSubset> </gridSubsets> <metaWidthHeight><int>9</int><int>6</int></metaWidthHeight> <cacheWarningSkips>\n   <warning>Default</warning>\n   <warning>FailedNearest</warning>\n </cacheWarningSkips></GeoServerLayer>";
        String url = "gwc/rest/layers/" + layerName + ".xml";
        MockHttpServletResponse response = super.putAsServletResponse(url, xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)mediator.tileLayerExists(layerName));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)mediator.getTileLayerByName(layerName);
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        MatcherAssert.assertThat((Object)info.getCacheWarningSkips(), (Matcher)Matchers.containsInAnyOrder((Object[])new DimensionWarning.WarningType[]{DimensionWarning.WarningType.Default, DimensionWarning.WarningType.FailedNearest}));
        Document dom = this.getAsDOM(url);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"", (Object)xpath.evaluate("//cacheWarningSkips/class", dom));
        Assert.assertEquals((Object)"Default", (Object)xpath.evaluate("//cacheWarningSkips/warning[1]", dom));
        Assert.assertEquals((Object)"FailedNearest", (Object)xpath.evaluate("//cacheWarningSkips/warning[2]", dom));
    }
}

