/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.TransactionType;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCTransactionListener;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GWCTransactionListenerTest {
    private GWC mediator;
    private GWCTransactionListener listener;

    @Before
    public void setUp() throws Exception {
        this.mediator = (GWC)Mockito.mock(GWC.class);
        this.listener = new GWCTransactionListener(this.mediator);
    }

    @Test
    public void testNoInteractionsInUnusedMethods() {
        TransactionRequest request = (TransactionRequest)Mockito.mock(TransactionRequest.class);
        TransactionRequest returned = this.listener.beforeTransaction(request);
        Assert.assertSame((Object)request, (Object)returned);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, this.mediator});
        this.listener.beforeCommit(request);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, this.mediator});
    }

    @Test
    public void testAfterTransactionUncommitted() {
        TransactionRequest request = (TransactionRequest)Mockito.mock(TransactionRequest.class);
        TransactionResponse result = (TransactionResponse)Mockito.mock(TransactionResponse.class);
        boolean committed = false;
        this.listener.afterTransaction(request, result, committed);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, result, this.mediator});
    }

    @Test
    public void testDataStoreChangeDoesNotPropagateExceptions() {
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        Mockito.when((Object)event.getSource()).thenThrow(new Throwable[]{new RuntimeException("fake")});
        try {
            this.listener.dataStoreChange(event);
        }
        catch (RuntimeException e) {
            Assert.fail((String)"Exception should have been eaten to prevent the transaction from failing due to a gwc integration error");
        }
    }

    @Test
    public void testDataStoreChangeOfNoInterest() {
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        Mockito.when((Object)event.getSource()).thenReturn(new Object());
        this.listener.dataStoreChange(event);
        ((TransactionEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)1))).getLayerName();
        ((TransactionEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)1))).getType();
        ((TransactionEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.times((int)1))).getSource();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{event, this.mediator});
    }

    @Test
    public void testDataStoreChangePostInsert() {
        InsertElementType insert = (InsertElementType)Mockito.mock(InsertElementType.class);
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        QName layerName = new QName("testType");
        Mockito.when((Object)event.getLayerName()).thenReturn((Object)layerName);
        Mockito.when((Object)event.getSource()).thenReturn((Object)insert);
        Mockito.when((Object)event.getType()).thenReturn((Object)TransactionEventType.POST_INSERT);
        this.listener.dataStoreChange(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mediator});
    }

    @Test
    public void testDataStoreChangeDoesNotAffectTileLayer() {
        InsertElementType insert = (InsertElementType)Mockito.mock(InsertElementType.class);
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        QName layerName = new QName("testType");
        Mockito.when((Object)event.getLayerName()).thenReturn((Object)layerName);
        Mockito.when((Object)event.getSource()).thenReturn((Object)insert);
        Mockito.when((Object)event.getType()).thenReturn((Object)TransactionEventType.PRE_INSERT);
        Mockito.when((Object)this.mediator.getTileLayersByFeatureType((String)ArgumentMatchers.eq((Object)layerName.getNamespaceURI()), (String)ArgumentMatchers.eq((Object)layerName.getLocalPart()))).thenReturn(Collections.emptySet());
        this.listener.dataStoreChange(event);
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).getTileLayersByFeatureType((String)ArgumentMatchers.eq((Object)layerName.getNamespaceURI()), (String)ArgumentMatchers.eq((Object)layerName.getLocalPart()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mediator});
    }

    @Test
    public void testDataStoreChangeInsert() {
        HashMap<Object, Object> extendedProperties = new HashMap<Object, Object>();
        ReferencedEnvelope affectedBounds = new ReferencedEnvelope(-180.0, 0.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.issueInsert(extendedProperties, affectedBounds);
        Assert.assertTrue((boolean)extendedProperties.containsKey("GWC_TRANSACTION_INFO_PLACEHOLDER"));
        Map placeHolder = (Map)extendedProperties.get("GWC_TRANSACTION_INFO_PLACEHOLDER");
        Assert.assertNotNull(placeHolder.get("theLayer"));
        Assert.assertSame((Object)affectedBounds, ((List)placeHolder.get("theLayer")).get(0));
        Assert.assertSame((Object)affectedBounds, ((List)placeHolder.get("theGroup")).get(0));
    }

    @Test
    public void testAfterTransactionCompoundCRS() throws Exception {
        HashMap<Object, Object> extendedProperties = new HashMap<Object, Object>();
        CoordinateReferenceSystem compoundCrs = CRS.decode((String)"EPSG:7415");
        ReferencedEnvelope3D transactionBounds = new ReferencedEnvelope3D(142892.0, 470783.0, 142900.0, 470790.0, 16.0, 20.0, compoundCrs);
        this.issueInsert(extendedProperties, (ReferencedEnvelope)transactionBounds);
        TransactionRequest request = (TransactionRequest)Mockito.mock(TransactionRequest.class);
        TransactionResponse result = (TransactionResponse)Mockito.mock(TransactionResponse.class);
        Mockito.when((Object)request.getExtendedProperties()).thenReturn(extendedProperties);
        Mockito.when((Object)this.mediator.getDeclaredCrs(ArgumentMatchers.anyString())).thenReturn((Object)compoundCrs);
        this.listener.afterTransaction(request, result, true);
        ReferencedEnvelope expectedBounds = new ReferencedEnvelope((Envelope)transactionBounds, (CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)compoundCrs));
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).truncate((String)ArgumentMatchers.eq((Object)"theLayer"), (ReferencedEnvelope)ArgumentMatchers.eq((Object)expectedBounds));
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).truncate((String)ArgumentMatchers.eq((Object)"theGroup"), (ReferencedEnvelope)ArgumentMatchers.eq((Object)expectedBounds));
    }

    @Test
    public void testAfterTransaction() throws Exception {
        HashMap<Object, Object> extendedProperties = new HashMap<Object, Object>();
        ReferencedEnvelope affectedBounds1 = new ReferencedEnvelope(-180.0, 0.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope affectedBounds2 = new ReferencedEnvelope(0.0, 180.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.issueInsert(extendedProperties, affectedBounds1);
        this.issueInsert(extendedProperties, affectedBounds2);
        TransactionRequest request = (TransactionRequest)Mockito.mock(TransactionRequest.class);
        TransactionResponse result = (TransactionResponse)Mockito.mock(TransactionResponse.class);
        Mockito.when((Object)request.getExtendedProperties()).thenReturn(extendedProperties);
        Mockito.when((Object)this.mediator.getDeclaredCrs(ArgumentMatchers.anyString())).thenReturn((Object)DefaultGeographicCRS.WGS84);
        this.listener.afterTransaction(request, result, true);
        ReferencedEnvelope expectedEnv = new ReferencedEnvelope(affectedBounds1);
        expectedEnv.expandToInclude((Envelope)affectedBounds2);
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).truncate((String)ArgumentMatchers.eq((Object)"theLayer"), (ReferencedEnvelope)ArgumentMatchers.eq((Object)expectedEnv));
        ((GWC)Mockito.verify((Object)this.mediator, (VerificationMode)Mockito.times((int)1))).truncate((String)ArgumentMatchers.eq((Object)"theGroup"), (ReferencedEnvelope)ArgumentMatchers.eq((Object)expectedEnv));
    }

    private void issueInsert(Map<Object, Object> extendedProperties, ReferencedEnvelope affectedBounds) {
        TransactionType transaction = (TransactionType)Mockito.mock(TransactionType.class);
        Mockito.when((Object)transaction.getExtendedProperties()).thenReturn(extendedProperties);
        TransactionEvent event = (TransactionEvent)Mockito.mock(TransactionEvent.class);
        Mockito.when((Object)event.getRequest()).thenReturn((Object)transaction);
        QName layerName = new QName("testType");
        Mockito.when((Object)event.getLayerName()).thenReturn((Object)layerName);
        InsertElementType insert = (InsertElementType)Mockito.mock(InsertElementType.class);
        Mockito.when((Object)event.getSource()).thenReturn((Object)insert);
        Mockito.when((Object)event.getType()).thenReturn((Object)TransactionEventType.PRE_INSERT);
        Mockito.when((Object)this.mediator.getTileLayersByFeatureType((String)ArgumentMatchers.eq((Object)layerName.getNamespaceURI()), (String)ArgumentMatchers.eq((Object)layerName.getLocalPart()))).thenReturn((Object)ImmutableSet.of((Object)"theLayer", (Object)"theGroup"));
        SimpleFeatureCollection affectedFeatures = (SimpleFeatureCollection)Mockito.mock(SimpleFeatureCollection.class);
        Mockito.when((Object)affectedFeatures.getBounds()).thenReturn((Object)affectedBounds);
        Mockito.when((Object)event.getAffectedFeatures()).thenReturn((Object)affectedFeatures);
        this.listener.dataStoreChange(event);
    }
}

