/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import java.io.File;
import org.geoserver.gwc.config.GeoserverXMLResourceProvider;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.util.IOUtils;
import org.geoserver.util.PropertyRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.Test;

public final class GWCExternalConfigTest
extends GeoServerSystemTestSupport {
    @Rule
    public PropertyRule configProp = PropertyRule.system((String)"GEOWEBCACHE_CONFIG_DIR");
    @Rule
    public PropertyRule cacheProp = PropertyRule.system((String)"GEOWEBCACHE_CACHE_DIR");
    private static final File rootTempDirectory;
    private static final String tempDirectory1;
    private static final String tempDirectory2;
    private static final String tempDirectory3;
    private static final String tempDirectory4;

    @Test
    public void testThatExternalDirectoryIsUsed() throws Exception {
        this.testUseCase(tempDirectory1, null, tempDirectory1);
        this.testUseCase(null, tempDirectory2, tempDirectory2);
        this.testUseCase(tempDirectory3, tempDirectory4, tempDirectory3);
    }

    private void testUseCase(String configDirPath, String cacheDirPath, String expectedConfigFirPath) {
        if (configDirPath == null) {
            this.configProp.clearValue();
        } else {
            this.configProp.setValue(configDirPath);
        }
        if (cacheDirPath == null) {
            this.cacheProp.clearValue();
        } else {
            this.cacheProp.setValue(cacheDirPath);
        }
        applicationContext.refresh();
        applicationContext.getBeansOfType(GeoserverXMLResourceProvider.class).values().forEach(bean -> {
            try {
                MatcherAssert.assertThat((Object)bean.getConfigDirectory(), (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)bean.getConfigDirectory().dir().getCanonicalPath(), (Matcher)Matchers.is((Object)expectedConfigFirPath));
                MatcherAssert.assertThat((Object)new File(bean.getLocation()).getCanonicalPath(), (Matcher)Matchers.is((Object)new File(expectedConfigFirPath, bean.getConfigFileName()).getCanonicalPath()));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        IOUtils.delete((File)rootTempDirectory);
    }

    static {
        try {
            rootTempDirectory = IOUtils.createTempDirectory((String)"gwc");
            tempDirectory1 = new File(rootTempDirectory, "test-case-1").getCanonicalPath();
            tempDirectory2 = new File(rootTempDirectory, "test-case-2").getCanonicalPath();
            tempDirectory3 = new File(rootTempDirectory, "test-case-3").getCanonicalPath();
            tempDirectory4 = new File(rootTempDirectory, "test-case-4").getCanonicalPath();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error initializing temporary directory.", exception);
        }
    }
}

